/*
 * Decompiled with CFR 0.152.
 */
package josx.vision;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Effect;
import javax.media.Format;
import javax.media.format.RGBFormat;

public abstract class VisionEffect
implements Effect {
    protected Format inputFormat;
    protected Format outputFormat;
    protected Format[] inputFormats = new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 1, -1)};
    protected Format[] outputFormats = new Format[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 1, -1)};

    public Format[] getSupportedInputFormats() {
        return this.inputFormats;
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return this.outputFormats;
        }
        if (this.matches(input, this.inputFormats) != null) {
            return new Format[]{this.outputFormats[0].intersects(input)};
        }
        return new Format[0];
    }

    public Format setInputFormat(Format input) {
        this.inputFormat = input;
        return input;
    }

    public Format setOutputFormat(Format output) {
        if (output == null || this.matches(output, this.outputFormats) == null) {
            return null;
        }
        RGBFormat incoming = (RGBFormat)output;
        Dimension size = incoming.getSize();
        int maxDataLength = incoming.getMaxDataLength();
        int lineStride = incoming.getLineStride();
        float frameRate = incoming.getFrameRate();
        if (size == null) {
            return null;
        }
        if (maxDataLength < size.width * size.height * 3) {
            maxDataLength = size.width * size.height * 3;
        }
        if (lineStride < size.width * 3) {
            lineStride = size.width * 3;
        }
        this.outputFormat = this.outputFormats[0].intersects((Format)new RGBFormat(size, maxDataLength, null, frameRate, -1, -1, -1, -1, -1, lineStride, -1, -1));
        return this.outputFormat;
    }

    public void open() {
    }

    public void close() {
    }

    public void reset() {
    }

    public Object getControl(String controlType) {
        return null;
    }

    public Object[] getControls() {
        return null;
    }

    protected Format matches(Format in, Format[] outs) {
        for (int i = 0; i < outs.length; ++i) {
            if (!in.matches(outs[i])) continue;
            return outs[i];
        }
        return null;
    }

    protected byte[] validateByteArraySize(Buffer buffer, int newSize) {
        byte[] typedArray;
        Object objectArray = buffer.getData();
        if (objectArray instanceof byte[]) {
            typedArray = (byte[])objectArray;
            if (typedArray.length >= newSize) {
                return typedArray;
            }
            byte[] tempArray = new byte[newSize];
            System.arraycopy(typedArray, 0, tempArray, 0, typedArray.length);
            typedArray = tempArray;
        } else {
            typedArray = new byte[newSize];
        }
        buffer.setData((Object)typedArray);
        return typedArray;
    }
}

