/*
 * Decompiled with CFR 0.152.
 */
package josx.vision;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Codec;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.UnsupportedPlugInException;
import javax.media.control.FormatControl;
import javax.media.control.TrackControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import josx.vision.ColorEffect;
import josx.vision.ColorListener;
import josx.vision.FlipEffect;
import josx.vision.LightListener;
import josx.vision.MotionDetectionEffect;
import josx.vision.MotionListener;
import josx.vision.Recorder;
import josx.vision.Region;
import josx.vision.RegionEffect;

public class Vision
extends Frame
implements ControllerListener {
    static int imageWidth = -1;
    static int imageHeight = -1;
    static float frameRate = 15.0f;
    static String snapshotFilename;
    static Processor p;
    static DataSource cds;
    static String cameraDevice;
    static String soundDevice;
    static boolean isRecording;
    static Recorder recorder;
    static boolean captureColor;
    static Vision visionFrame;
    static ColorEffect colorEffect;
    static FlipEffect flipEffect;
    static RegionEffect regionEffect;
    static MotionDetectionEffect motionDetectionEffect;
    private Object waitSync = new Object();
    private boolean stateTransitionOK = true;
    private static Properties videoProperties;
    private static final String DEFAULT_VIDEO_DEV_NAME = "vfw:Logitech USB Video Camera:0";
    private static final String DEFAULT_SOUND_DEV_NAME = "DirectSoundCapture";
    private static Region[] regions;
    private static boolean takeSnapshot;
    private static final long serialVersionUID = 3257286945972432951L;

    public Vision(String title) {
        super(title);
    }

    public static Frame getFrame() {
        return visionFrame;
    }

    public boolean open(DataSource tds) {
        Component cc;
        cds = Manager.createCloneableDataSource((DataSource)tds);
        try {
            p = Manager.createProcessor((DataSource)cds);
        }
        catch (Exception e) {
            System.err.println("Failed to create a processor from the given datasource: " + e);
            return false;
        }
        p.addControllerListener((ControllerListener)this);
        p.configure();
        if (!this.waitForState(180)) {
            System.err.println("Failed to configure the processor.");
            return false;
        }
        p.setContentDescriptor(null);
        TrackControl[] tc = p.getTrackControls();
        if (tc == null) {
            System.err.println("Failed to obtain track controls from the processor.");
            return false;
        }
        TrackControl videoTrack = null;
        for (int i = 0; i < tc.length; ++i) {
            if (!(tc[i].getFormat() instanceof VideoFormat)) continue;
            videoTrack = tc[i];
            break;
        }
        if (videoTrack == null) {
            System.err.println("The input media does not contain a video track.");
            return false;
        }
        try {
            Codec[] codec = new Codec[]{flipEffect, motionDetectionEffect, regionEffect, colorEffect};
            videoTrack.setCodecChain(codec);
        }
        catch (UnsupportedPlugInException e) {
            System.err.println("The processor does not support effects.");
            return false;
        }
        p.prefetch();
        if (!this.waitForState(500)) {
            System.err.println("Failed to realize the processor.");
            return false;
        }
        this.setLayout(new BorderLayout());
        Component vc = p.getVisualComponent();
        if (vc != null) {
            this.add("Center", vc);
        }
        if ((cc = p.getControlPanelComponent()) != null) {
            this.add("South", cc);
        }
        p.start();
        this.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                p.close();
                System.exit(0);
            }
        });
        return true;
    }

    public static void stopViewer() {
        visionFrame.setVisible(false);
        p.close();
    }

    public void addNotify() {
        super.addNotify();
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() != state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof ConfigureCompleteEvent || evt instanceof RealizeCompleteEvent || evt instanceof PrefetchCompleteEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            p.close();
            System.out.println("End of Media");
            System.exit(0);
        }
    }

    public static void startViewer(String title) {
        CaptureDeviceInfo device;
        String videoPropFile = System.getProperty("video.properties", "video.properties");
        try {
            FileInputStream fis = new FileInputStream(new File(videoPropFile));
            videoProperties = new Properties();
            videoProperties.load(fis);
        }
        catch (IOException ioe) {
            System.err.println("Failed to read property file");
            System.exit(1);
        }
        cameraDevice = videoProperties.getProperty("video-device-name", DEFAULT_VIDEO_DEV_NAME);
        soundDevice = videoProperties.getProperty("sound-device-name", DEFAULT_SOUND_DEV_NAME);
        if (imageWidth < 0) {
            imageWidth = Integer.parseInt(videoProperties.getProperty("resolution-x", "320"));
        }
        if (imageHeight < 0) {
            imageHeight = Integer.parseInt(videoProperties.getProperty("resolution-y", "320"));
        }
        if ((device = CaptureDeviceManager.getDevice((String)cameraDevice)) == null) {
            System.out.println("No device found [ " + cameraDevice + "]");
            System.exit(1);
        }
        MediaLocator ml = device.getLocator();
        DataSource tds = null;
        try {
            tds = Manager.createDataSource((MediaLocator)ml);
        }
        catch (Exception e) {
            System.err.println("Failed to create a datasource");
            System.exit(1);
        }
        FormatControl[] formatControls = ((CaptureDevice)tds).getFormatControls();
        RGBFormat format = new RGBFormat(new Dimension(imageWidth, imageHeight), imageWidth * imageHeight * 3 + 4, Format.byteArray, frameRate, 24, 3, 2, 1, 3, -1, 1, -1);
        if (formatControls == null || formatControls.length == 0) {
            System.out.println("No format controls");
            System.exit(1);
        }
        for (int i = 0; i < formatControls.length; ++i) {
            if (formatControls[i] == null) continue;
            formatControls[i].setFormat((Format)format);
        }
        visionFrame = new Vision(title);
        if (!visionFrame.open(tds)) {
            System.exit(1);
        }
    }

    public static void playSound(String fileName) {
        try {
            AudioInputStream stream = AudioSystem.getAudioInputStream(new File(fileName));
            AudioFormat format = stream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, stream.getFormat(), (int)stream.getFrameLength() * format.getFrameSize());
            Clip clip = (Clip)AudioSystem.getLine(info);
            clip.open(stream);
            clip.start();
        }
        catch (IOException e) {
            System.err.println("Audio file not found");
        }
        catch (LineUnavailableException e) {
            System.err.println("Could not play the audio file");
        }
        catch (UnsupportedAudioFileException e) {
            System.err.println("Unsupported Audio File Format");
        }
    }

    public static void addRectRegion(int region, int x, int y, int width, int height) {
        Vision.regions[region - 1] = new Region(x, y, width, height);
    }

    public static Region[] getRegions() {
        return regions;
    }

    public static void setFrameRate(float rate) {
        frameRate = rate;
    }

    public static void setImageSize(int width, int height) {
        imageWidth = width;
        imageHeight = height;
    }

    public static void addMotionListener(int region, MotionListener ml) {
        regions[region - 1].addMotionListener(ml);
    }

    public static void addColorListener(int region, ColorListener cl, int color) {
        regions[region - 1].addColorListener(cl, color);
    }

    public static void addLightListener(int region, LightListener ll) {
        regions[region - 1].addLightListener(ll);
    }

    static boolean takeSnapshot() {
        return takeSnapshot;
    }

    public static void snapshot(String filename) {
        snapshotFilename = filename;
        takeSnapshot = true;
    }

    static void setSnapshot(boolean snap) {
        takeSnapshot = snap;
    }

    public static void writeImage(String fn, byte[] data, int width, int height) throws FileNotFoundException, IOException {
        FileOutputStream fOut = new FileOutputStream(fn);
        JPEGImageEncoder jpeg_encode = JPEGCodec.createJPEGEncoder((OutputStream)fOut);
        int[] ints = new int[data.length / 3];
        int k = 0;
        for (int i = height - 1; i > 0; --i) {
            for (int j = 0; j < width; ++j) {
                ints[k++] = 0xFF000000 | (data[i * width * 3 + j * 3 + 2] & 0xFF) << 16 | (data[i * width * 3 + j * 3 + 1] & 0xFF) << 8 | data[i * width * 3 + j * 3] & 0xFF;
            }
        }
        BufferedImage image = new BufferedImage(width, height, 1);
        image.setRGB(0, 0, width, height, ints, 0, width);
        jpeg_encode.encode(image);
        fOut.close();
    }

    public static void startRecorder(String fileName, int millis) {
        recorder = new Recorder(fileName, millis);
        recorder.start();
    }

    public static boolean isRecording() {
        return isRecording;
    }

    public static void stopRecording() {
        Recorder.stopRecording();
    }

    public static int getAvgRed(int region) {
        return Vision.colorEffect.averageRed[region - 1];
    }

    public static int getAvgGreen(int region) {
        return Vision.colorEffect.averageGreen[region - 1];
    }

    public static int getAvgBlue(int region) {
        return Vision.colorEffect.averageBlue[region - 1];
    }

    public static int getAvgRGB(int region) {
        return new Color(Vision.getAvgRed(region), Vision.getAvgGreen(region), Vision.getAvgBlue(region)).getRGB() & 0xFFFFFF;
    }

    public static void flipHorizontal(boolean flip) {
        Vision.flipEffect.flip = flip;
    }

    static {
        isRecording = false;
        captureColor = false;
        colorEffect = new ColorEffect();
        flipEffect = new FlipEffect();
        regionEffect = new RegionEffect();
        motionDetectionEffect = new MotionDetectionEffect();
        regions = new Region[Region.MAX_REGIONS];
        takeSnapshot = false;
    }
}

