/*
 * Decompiled with CFR 0.152.
 */
package josx.vision;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import josx.vision.Font;
import josx.vision.Region;
import josx.vision.RegionControl;
import josx.vision.Vision;
import josx.vision.VisionEffect;

public class RegionEffect
extends VisionEffect {
    public boolean show = true;
    private Control[] controls;

    public int process(Buffer inBuffer, Buffer outBuffer) {
        int outputDataLength = ((VideoFormat)this.outputFormat).getMaxDataLength();
        this.validateByteArraySize(outBuffer, outputDataLength);
        Region[] regions = Vision.getRegions();
        outBuffer.setLength(outputDataLength);
        outBuffer.setFormat(this.outputFormat);
        outBuffer.setFlags(inBuffer.getFlags());
        byte[] inData = (byte[])inBuffer.getData();
        byte[] outData = (byte[])outBuffer.getData();
        RGBFormat vfIn = (RGBFormat)inBuffer.getFormat();
        Dimension sizeIn = vfIn.getSize();
        int pixStrideIn = vfIn.getPixelStride();
        int lineStrideIn = vfIn.getLineStride();
        if (outData.length < sizeIn.width * sizeIn.height * 3) {
            System.out.println("the buffer is not full");
            return 1;
        }
        System.arraycopy(inData, 0, outData, 0, inData.length);
        if (!this.show) {
            return 0;
        }
        for (int i = 0; i < regions.length; ++i) {
            int j;
            if (regions[i] == null) continue;
            int rx = regions[i].getX();
            int ry = regions[i].getY();
            int rw = regions[i].getWidth();
            int rh = regions[i].getHeight();
            int offx = rx * pixStrideIn;
            int offy = ry * lineStrideIn;
            int width = rw * pixStrideIn;
            int height = (rh - 1) * lineStrideIn;
            for (j = 0; j < rh; ++j) {
                outData[offx + offy + j * lineStrideIn] = 0;
                outData[offx + offy + j * lineStrideIn + 1] = 0;
                outData[offx + offy + j * lineStrideIn + 2] = -1;
            }
            for (j = 0; j < rh; ++j) {
                outData[offx + width + offy + j * lineStrideIn - 3] = 0;
                outData[offx + width + offy + j * lineStrideIn - 2] = 0;
                outData[offx + width + offy + j * lineStrideIn - 1] = -1;
            }
            for (j = 0; j < rw; ++j) {
                outData[offx + offy + j * pixStrideIn] = 0;
                outData[offx + offy + j * pixStrideIn + 1] = 0;
                outData[offx + offy + j * pixStrideIn + 2] = -1;
            }
            for (j = 0; j < rw; ++j) {
                outData[offx + offy + height + j * pixStrideIn] = 0;
                outData[offx + offy + height + j * pixStrideIn + 1] = 0;
                outData[offx + offy + height + j * pixStrideIn + 2] = -1;
            }
            Font.println("" + (i + 1), 10, rx + 5, ry + 10, (byte)-1, (byte)0, (byte)0, outBuffer);
        }
        return 0;
    }

    public String getName() {
        return "Region Effect";
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new RegionControl(this);
        }
        return this.controls;
    }
}

