/*
 * Decompiled with CFR 0.152.
 */
package josx.vision;

import josx.vision.ColorListener;
import josx.vision.LightListener;
import josx.vision.MotionListener;

public class Region {
    public static int MAX_REGIONS = 32;
    private int x;
    private int y;
    private int w;
    private int h;
    private static final int MAX_MOTION_LISTENERS = 32;
    private static final int MAX_COLOR_LISTENERS = 32;
    private static final int MAX_LIGHT_LISTENERS = 32;
    private MotionListener[] motionListeners = new MotionListener[32];
    private int numMotionListeners = 0;
    private ColorListener[] colorListeners = new ColorListener[32];
    private int numColorListeners = 0;
    private int[] colors = new int[32];
    private LightListener[] lightListeners = new LightListener[32];
    private int numLightListeners = 0;

    public Region(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public boolean inRegion(int tx, int ty) {
        return tx >= this.x && ty >= this.y && tx <= this.x + this.w && ty <= this.y + this.h;
    }

    public void addMotionListener(MotionListener ml) {
        this.motionListeners[this.numMotionListeners++] = ml;
    }

    public void addColorListener(ColorListener cl, int color) {
        this.colors[this.numColorListeners] = color;
        this.colorListeners[this.numColorListeners++] = cl;
    }

    public void addLightListener(LightListener ll) {
        this.lightListeners[this.numLightListeners++] = ll;
    }

    public MotionListener[] getMotionListeners() {
        MotionListener[] ml = new MotionListener[this.numMotionListeners];
        for (int i = 0; i < this.numMotionListeners; ++i) {
            ml[i] = this.motionListeners[i];
        }
        return ml;
    }

    public ColorListener[] getColorListeners() {
        ColorListener[] cl = new ColorListener[this.numColorListeners];
        for (int i = 0; i < this.numColorListeners; ++i) {
            cl[i] = this.colorListeners[i];
        }
        return cl;
    }

    public int[] getColors() {
        return this.colors;
    }

    public LightListener[] getLightListeners() {
        LightListener[] ll = new LightListener[this.numLightListeners];
        for (int i = 0; i < this.numLightListeners; ++i) {
            ll[i] = this.lightListeners[i];
        }
        return ll;
    }
}

