/*
 * Decompiled with CFR 0.152.
 */
package josx.vision;

import java.io.IOException;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Processor;
import javax.media.ProcessorModel;
import javax.media.ResourceUnavailableEvent;
import javax.media.StopByRequestEvent;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import javax.media.protocol.SourceCloneable;
import josx.vision.Vision;

public class Recorder
extends Thread
implements ControllerListener {
    private static Processor p;
    private Object waitSync = new Object();
    private boolean stateTransitionOK = true;
    private boolean eom = false;
    private boolean failed = false;
    private String filename;
    private int millis;

    public Recorder(String filename, int millis) {
        this.filename = filename;
        this.millis = millis;
    }

    public static void stopRecording() {
        p.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Vision.isRecording = true;
        DataSource ds = ((SourceCloneable)Vision.cds).createClone();
        Format[] formats = new Format[]{new AudioFormat("LINEAR"), new VideoFormat("cvid")};
        FileTypeDescriptor outputType = new FileTypeDescriptor("video.quicktime");
        CaptureDeviceInfo di = CaptureDeviceManager.getDevice((String)Vision.soundDevice);
        DataSource[] dss = new DataSource[2];
        dss[0] = ds;
        System.out.println("Creating Audio data source");
        try {
            dss[1] = Manager.createDataSource((MediaLocator)di.getLocator());
        }
        catch (Exception e) {
            System.out.println("Failed to create Audio data source " + e.getMessage());
            System.exit(1);
        }
        System.out.println("Creating Merging data source");
        DataSource mds = null;
        try {
            mds = Manager.createMergingDataSource((DataSource[])dss);
        }
        catch (Exception e) {
            System.out.println("Failed to merge data sources " + e.getMessage());
            System.exit(-1);
        }
        try {
            p = Manager.createRealizedProcessor((ProcessorModel)new ProcessorModel(mds, formats, (ContentDescriptor)outputType));
        }
        catch (Exception e) {
            System.err.println("Failed to create a processor from the given datasource: " + e);
            System.exit(-1);
        }
        p.addControllerListener((ControllerListener)this);
        DataSource source = p.getDataOutput();
        MediaLocator dest = new MediaLocator("file://" + this.filename + ".mov");
        DataSink filewriter = null;
        try {
            filewriter = Manager.createDataSink((DataSource)source, (MediaLocator)dest);
            filewriter.open();
        }
        catch (Exception e) {
            System.out.println("Failed to create file writer");
            System.exit(-1);
        }
        try {
            filewriter.start();
        }
        catch (IOException e) {
            System.exit(-1);
        }
        p.start();
        this.waitForState(600);
        System.out.println("Recording...");
        if (this.millis > 0) {
            this.playToEndOfMedia(this.millis);
        } else {
            try {
                Object e = this.waitSync;
                synchronized (e) {
                    this.waitSync.wait();
                }
            }
            catch (InterruptedException ioe) {
                // empty catch block
            }
        }
        p.close();
        Vision.isRecording = false;
        System.out.println("Finished");
        filewriter.close();
        Vision.p.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void controllerUpdate(ControllerEvent evt) {
        System.out.println(this.getClass().getName() + evt);
        if (evt instanceof StopByRequestEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof ResourceUnavailableEvent) {
            Object object = this.waitSync;
            synchronized (object) {
                this.stateTransitionOK = false;
                this.failed = true;
                this.waitSync.notifyAll();
            }
        } else if (evt instanceof EndOfMediaEvent) {
            this.eom = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitForState(int state) {
        Object object = this.waitSync;
        synchronized (object) {
            try {
                while (p.getState() != state && this.stateTransitionOK) {
                    this.waitSync.wait();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.stateTransitionOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean playToEndOfMedia(int timeOutMillis) {
        long startTime = System.currentTimeMillis();
        this.eom = false;
        this.failed = false;
        Recorder recorder = this;
        synchronized (recorder) {
            while (!this.eom && !this.failed) {
                try {
                    this.wait(timeOutMillis);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - startTime <= (long)timeOutMillis) continue;
            }
        }
        return this.eom && !this.failed;
    }
}

