/*
 * Decompiled with CFR 0.152.
 */
package josx.vision;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import josx.vision.Font;
import josx.vision.MotionDetectionControl;
import josx.vision.MotionListener;
import josx.vision.Region;
import josx.vision.Vision;
import josx.vision.VisionEffect;

public class MotionDetectionEffect
extends VisionEffect {
    private int[] blobCount = new int[Region.MAX_REGIONS];
    public int OPTIMIZATION = 0;
    public int THRESHOLD_MAX = 10000;
    public int THRESHOLD_INC = 1000;
    public int THRESHOLD_INIT = 1000;
    private byte[] refData;
    private byte[] bwData;
    private int avg_ref_intensity;
    private int avg_img_intensity;
    public int threshold = 10;
    public int blob_threshold = this.THRESHOLD_INIT;
    public boolean debug = false;
    private Control[] controls;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process(Buffer inBuffer, Buffer outBuffer) {
        int i;
        int ip;
        int outputDataLength = ((VideoFormat)this.outputFormat).getMaxDataLength();
        this.validateByteArraySize(outBuffer, outputDataLength);
        outBuffer.setLength(outputDataLength);
        outBuffer.setFormat(this.outputFormat);
        outBuffer.setFlags(inBuffer.getFlags());
        byte[] inData = (byte[])inBuffer.getData();
        byte[] outData = (byte[])outBuffer.getData();
        RGBFormat vfIn = (RGBFormat)inBuffer.getFormat();
        Dimension sizeIn = vfIn.getSize();
        int pixStrideIn = vfIn.getPixelStride();
        int lineStrideIn = vfIn.getLineStride();
        int avg = 0;
        int refDataInt = 0;
        int inDataInt = 0;
        if (Vision.takeSnapshot()) {
            try {
                Vision.writeImage(Vision.snapshotFilename, inData, Vision.imageWidth, Vision.imageHeight);
            }
            catch (Exception e) {
                System.out.println("Failed to take snapshot");
            }
            finally {
                Vision.setSnapshot(false);
            }
        }
        if (this.refData == null) {
            this.refData = new byte[outputDataLength];
            this.bwData = new byte[outputDataLength];
            System.arraycopy(inData, 0, this.refData, 0, inData.length);
            System.arraycopy(inData, 0, outData, 0, inData.length);
            for (int ip2 = 0; ip2 < outputDataLength; ++ip2) {
                avg += this.refData[ip2] & 0xFF;
            }
            this.avg_ref_intensity = avg / outputDataLength;
            return 0;
        }
        if (outData.length < sizeIn.width * sizeIn.height * 3) {
            System.out.println("the buffer is not full");
            return 1;
        }
        for (ip = 0; ip < outputDataLength; ++ip) {
            avg += inData[ip] & 0xFF;
        }
        this.avg_img_intensity = avg / outputDataLength;
        int correction = this.avg_ref_intensity < this.avg_img_intensity ? this.avg_img_intensity - this.avg_ref_intensity : this.avg_ref_intensity - this.avg_img_intensity;
        this.avg_ref_intensity = this.avg_img_intensity;
        int op = 0;
        ip = 0;
        for (int ii = 0; ii < outputDataLength / pixStrideIn; ++ii) {
            byte result;
            refDataInt = this.refData[ip] & 0xFF;
            int r = refDataInt > (inDataInt = inData[ip++] & 0xFF) ? refDataInt - inDataInt : inDataInt - refDataInt;
            refDataInt = this.refData[ip] & 0xFF;
            inDataInt = inData[ip++] & 0xFF;
            int g = refDataInt > inDataInt ? refDataInt - inDataInt : inDataInt - refDataInt;
            refDataInt = this.refData[ip] & 0xFF;
            inDataInt = inData[ip++] & 0xFF;
            int b = refDataInt > inDataInt ? refDataInt - inDataInt : inDataInt - refDataInt;
            if ((result = (byte)Math.sqrt((double)((r -= r < correction ? r : correction) * r + (g -= g < correction ? g : correction) * g + (b -= b < correction ? b : correction) * b) / 3.0)) > (byte)this.threshold) {
                this.bwData[op++] = -1;
                this.bwData[op++] = -1;
                this.bwData[op++] = -1;
                continue;
            }
            this.bwData[op++] = result;
            this.bwData[op++] = result;
            this.bwData[op++] = result;
        }
        Region[] regions = Vision.getRegions();
        for (i = 0; i < regions.length; ++i) {
            this.blobCount[i] = 0;
        }
        for (op = lineStrideIn + 3; op < outputDataLength - lineStrideIn - 3; op += 3) {
            for (i = 0; i < 1 && (this.bwData[op + 2] & 0xFF) >= 255 && (this.bwData[op + 2 - lineStrideIn] & 0xFF) >= 255 && (this.bwData[op + 2 + lineStrideIn] & 0xFF) >= 255 && (this.bwData[op + 2 - 3] & 0xFF) >= 255 && (this.bwData[op + 2 + 3] & 0xFF) >= 255 && (this.bwData[op + 2 - lineStrideIn + 3] & 0xFF) >= 255 && (this.bwData[op + 2 - lineStrideIn - 3] & 0xFF) >= 255 && (this.bwData[op + 2 + lineStrideIn - 3] & 0xFF) >= 255 && (this.bwData[op + 2 + lineStrideIn + 3] & 0xFF) >= 255; ++i) {
                this.bwData[op] = 0;
                this.bwData[op + 1] = 0;
                int yy = op / lineStrideIn;
                int xx = op % lineStrideIn / pixStrideIn;
                for (int j = 0; j < Region.MAX_REGIONS; ++j) {
                    if (regions[j] == null || !regions[j].inRegion(xx, yy)) continue;
                    int n = j;
                    this.blobCount[n] = this.blobCount[n] + 1;
                }
            }
        }
        for (i = 0; i < Region.MAX_REGIONS && regions[i] != null; ++i) {
            if (this.blobCount[i] <= this.blob_threshold) continue;
            MotionListener[] ml = regions[i].getMotionListeners();
            for (int j = 0; j < ml.length; ++j) {
                ml[j].motionDetected(i + 1);
            }
            if (this.debug) {
                this.sample_down(inData, outData, 0, 0, sizeIn.width, sizeIn.height, lineStrideIn, pixStrideIn);
                Font.println("original picture", 1, 0, 0, (byte)-1, (byte)-1, (byte)-1, outBuffer);
                this.sample_down(this.refData, outData, 0, sizeIn.height / 2, sizeIn.width, sizeIn.height, lineStrideIn, pixStrideIn);
                Font.println("reference picture", 1, 0, sizeIn.height, (byte)-1, (byte)-1, (byte)-1, outBuffer);
                this.sample_down(this.bwData, outData, sizeIn.width / 2, 0, sizeIn.width, sizeIn.height, lineStrideIn, pixStrideIn);
                Font.println("motion detection pic", 1, sizeIn.width / 2, 0, (byte)-1, (byte)-1, (byte)-1, outBuffer);
            } else {
                System.arraycopy(inData, 0, outData, 0, inData.length);
            }
            System.arraycopy(inData, 0, this.refData, 0, inData.length);
            return 0;
        }
        System.arraycopy(inData, 0, outData, 0, inData.length);
        return 0;
    }

    public String getName() {
        return "Motion Detection Effect";
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new MotionDetectionControl(this);
        }
        return this.controls;
    }

    void sample_down(byte[] inData, byte[] outData, int X, int Y, int width, int height, int lineStrideIn, int pixStrideIn) {
        for (int y = 0; y < height / 2; ++y) {
            int p1 = y * 2 * lineStrideIn;
            int p2 = p1 + pixStrideIn;
            int p3 = p1 + lineStrideIn;
            int p4 = p3 + pixStrideIn;
            int op = lineStrideIn * y + lineStrideIn * Y + X * pixStrideIn;
            for (int i = 0; i < width / 2; ++i) {
                outData[op++] = (byte)(((inData[p1++] & 0xFF) + (inData[p2++] & 0xFF) + (inData[p3++] & 0xFF) + (inData[p4++] & 0xFF)) / 4);
                outData[op++] = (byte)(((inData[p1++] & 0xFF) + (inData[p2++] & 0xFF) + (inData[p3++] & 0xFF) + (inData[p4++] & 0xFF)) / 4);
                outData[op++] = (byte)(((inData[p1++] & 0xFF) + (inData[p2++] & 0xFF) + (inData[p3++] & 0xFF) + (inData[p4++] & 0xFF)) / 4);
                p1 += 3;
                p2 += 3;
                p3 += 3;
                p4 += 3;
            }
        }
    }
}

