/*
 * Decompiled with CFR 0.152.
 */
package josx.vision;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.Control;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import josx.vision.MotionDetectionEffect;

public class MotionDetectionControl
implements Control,
ActionListener,
ChangeListener {
    private Component component;
    private JButton button;
    private JSlider threshold;
    private JLabel label;
    private MotionDetectionEffect motion;

    public MotionDetectionControl(MotionDetectionEffect motion) {
        this.motion = motion;
    }

    public Component getControlComponent() {
        if (this.component == null) {
            this.label = new JLabel("Set Motion threshold:");
            this.button = new JButton("Motion Debug");
            this.button.addActionListener(this);
            this.button.setToolTipText("Click to turn debugging mode on/off");
            this.threshold = new JSlider(0, 0, this.motion.THRESHOLD_MAX / 1000, this.motion.THRESHOLD_INIT / 1000);
            this.threshold.setMajorTickSpacing(this.motion.THRESHOLD_INC / 1000);
            this.threshold.setPaintLabels(true);
            this.threshold.addChangeListener(this);
            Panel componentPanel = new Panel();
            componentPanel.setLayout(new BorderLayout());
            componentPanel.add("South", this.button);
            componentPanel.add("Center", this.threshold);
            componentPanel.add("North", this.label);
            componentPanel.invalidate();
            this.component = componentPanel;
        }
        return this.component;
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.button) {
            this.motion.debug = !this.motion.debug;
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object o = e.getSource();
        if (o == this.threshold) {
            this.motion.blob_threshold = this.threshold.getValue() * 1000;
        }
    }
}

