/*
 * Decompiled with CFR 0.152.
 */
package josx.vision;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import josx.vision.FlipControl;
import josx.vision.VisionEffect;

public class FlipEffect
extends VisionEffect {
    public boolean flip = false;
    private Control[] controls;

    public int process(Buffer inBuffer, Buffer outBuffer) {
        int outputDataLength = ((VideoFormat)this.outputFormat).getMaxDataLength();
        this.validateByteArraySize(outBuffer, outputDataLength);
        outBuffer.setLength(outputDataLength);
        outBuffer.setFormat(this.outputFormat);
        outBuffer.setFlags(inBuffer.getFlags());
        byte[] inData = (byte[])inBuffer.getData();
        byte[] outData = (byte[])outBuffer.getData();
        RGBFormat vfIn = (RGBFormat)inBuffer.getFormat();
        Dimension sizeIn = vfIn.getSize();
        int pixStrideIn = vfIn.getPixelStride();
        int lineStrideIn = vfIn.getLineStride();
        if (outData.length < sizeIn.width * sizeIn.height * 3) {
            System.out.println("the buffer is not full");
            return 1;
        }
        int lines = inData.length / lineStrideIn;
        int pixsPerLine = lineStrideIn / pixStrideIn;
        if (!this.flip) {
            System.arraycopy(inData, 0, outData, 0, inData.length);
            return 0;
        }
        byte[] buf = new byte[lineStrideIn];
        int pos = 0;
        for (int i = 0; i < lines; ++i) {
            for (int j = 0; j < pixsPerLine; ++j) {
                for (int k = 0; k < 3; ++k) {
                    buf[lineStrideIn - j * pixStrideIn - 3 + k] = inData[pos + j * pixStrideIn + k];
                }
            }
            System.arraycopy(buf, 0, outData, pos, lineStrideIn);
            pos += lineStrideIn;
        }
        return 0;
    }

    public String getName() {
        return "Flip Effect";
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new FlipControl(this);
        }
        return this.controls;
    }
}

