/*
 * Decompiled with CFR 0.152.
 */
package josx.vision;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import josx.vision.ColorDetectionControl;
import josx.vision.ColorListener;
import josx.vision.LightListener;
import josx.vision.Region;
import josx.vision.Vision;
import josx.vision.VisionEffect;

public class ColorEffect
extends VisionEffect {
    private static final int INIT_PIXEL_THRESHOLD = 16;
    private static final int LIGHT_THRESHOLD = 192;
    public static final int MAX_PIXEL_THRESHOLD = 40;
    public static final int MIN_PIXEL_THRESHOLD = 0;
    public static final int PIXEL_THRESHOLD_INC = 4;
    public static final float INIT_PROPORTION = 0.25f;
    public static final float MAX_PROPORTION = 0.5f;
    public static final float MIN_PROPORTION = 0.05f;
    public static final float PROPORTION_INC = 0.05f;
    public int[] averageRed = new int[Region.MAX_REGIONS];
    public int[] averageGreen = new int[Region.MAX_REGIONS];
    public int[] averageBlue = new int[Region.MAX_REGIONS];
    public static int pixelThreshold = 16;
    public static float requiredProportion = 0.25f;
    private Control[] controls;

    public int process(Buffer inBuffer, Buffer outBuffer) {
        int i;
        int outputDataLength = ((VideoFormat)this.outputFormat).getMaxDataLength();
        this.validateByteArraySize(outBuffer, outputDataLength);
        outBuffer.setLength(outputDataLength);
        outBuffer.setFormat(this.outputFormat);
        outBuffer.setFlags(inBuffer.getFlags());
        byte[] inData = (byte[])inBuffer.getData();
        byte[] outData = (byte[])outBuffer.getData();
        RGBFormat vfIn = (RGBFormat)inBuffer.getFormat();
        Dimension sizeIn = vfIn.getSize();
        int pixStrideIn = vfIn.getPixelStride();
        int lineStrideIn = vfIn.getLineStride();
        if (outData.length < sizeIn.width * sizeIn.height * 3) {
            System.out.println("the buffer is not full");
            return 1;
        }
        System.arraycopy(inData, 0, outData, 0, inData.length);
        Region[] regions = Vision.getRegions();
        int bestRegion = -1;
        int bestListener = -1;
        float bestProportion = -1.0f;
        for (i = 0; i < regions.length; ++i) {
            if (regions[i] == null) continue;
            ColorListener[] cl = regions[i].getColorListeners();
            int[] colors = regions[i].getColors();
            if (cl.length == 0) continue;
            int rx = regions[i].getX();
            int ry = regions[i].getY();
            int width = regions[i].getWidth();
            int height = regions[i].getHeight();
            for (int j = 0; j < cl.length; ++j) {
                float thisProportion;
                int r = colors[j] >> 16 & 0xFF;
                int g = colors[j] >> 8 & 0xFF;
                int b = colors[j] & 0xFF;
                int pixCount = 0;
                int totalPixs = 0;
                int aR = 0;
                int aG = 0;
                int aB = 0;
                for (int ii = ry; ii < ry + height; ++ii) {
                    for (int jj = rx; jj < rx + width; ++jj) {
                        int pos = ii * lineStrideIn + jj * pixStrideIn;
                        int tr = inData[pos + 2] & 0xFF;
                        int tg = inData[pos + 1] & 0xFF;
                        int tb = inData[pos] & 0xFF;
                        aR += tr;
                        aG += tg;
                        aB += tb;
                        ++totalPixs;
                        if (Math.abs(tr - r) > pixelThreshold || Math.abs(tg - g) > pixelThreshold || Math.abs(tb - b) > pixelThreshold) continue;
                        ++pixCount;
                    }
                }
                this.averageRed[i] = aR / totalPixs;
                this.averageGreen[i] = aG / totalPixs;
                this.averageBlue[i] = aB / totalPixs;
                if (Vision.captureColor) {
                    System.out.println("Color = " + aR / totalPixs + " , " + aG / totalPixs + " , " + aB / totalPixs);
                }
                if (!((thisProportion = (float)pixCount / (float)totalPixs) > bestProportion) || !(thisProportion > requiredProportion)) continue;
                bestProportion = thisProportion;
                bestRegion = i;
                bestListener = j;
            }
        }
        if (bestRegion >= 0) {
            regions[bestRegion].getColorListeners()[bestListener].colorDetected(bestRegion + 1, regions[bestRegion].getColors()[bestListener]);
        }
        bestRegion = -1;
        bestListener = -1;
        bestProportion = -1.0f;
        for (i = 0; i < regions.length; ++i) {
            LightListener[] ll;
            if (regions[i] == null || (ll = regions[i].getLightListeners()).length == 0) continue;
            int rx = regions[i].getX();
            int ry = regions[i].getY();
            int width = regions[i].getWidth();
            int height = regions[i].getHeight();
            for (int j = 0; j < ll.length; ++j) {
                int pixCount = 0;
                int totalPixs = 0;
                for (int ii = ry; ii < ry + height; ++ii) {
                    for (int jj = rx; jj < rx + width; ++jj) {
                        int pos = ii * lineStrideIn + jj * pixStrideIn;
                        int tr = inData[pos + 2] & 0xFF;
                        int tg = inData[pos + 1] & 0xFF;
                        int tb = inData[pos] & 0xFF;
                        ++totalPixs;
                        if (tr < 192 || tg < 192 || tb < 192) continue;
                        ++pixCount;
                    }
                }
                float thisProportion = (float)pixCount / (float)totalPixs;
                if (!(thisProportion > bestProportion) || !(thisProportion > requiredProportion)) continue;
                bestProportion = thisProportion;
                bestRegion = i;
                bestListener = j;
            }
        }
        if (bestRegion > 0) {
            LightListener[] ll = regions[bestRegion].getLightListeners();
            for (int i2 = 0; i2 < ll.length; ++i2) {
                ll[i2].lightDetected(bestRegion + 1);
            }
        }
        return 0;
    }

    public String getName() {
        return "Color Effect";
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[1];
            this.controls[0] = new ColorDetectionControl(this);
        }
        return this.controls;
    }
}

