/*
 * Decompiled with CFR 0.152.
 */
package josx.vision;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.Control;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import josx.vision.ColorEffect;

public class ColorDetectionControl
implements Control,
ActionListener,
ChangeListener {
    private Component component;
    private JButton button;
    private JSlider threshold;
    private JSlider proportionThreshold;
    private JLabel label;
    private JLabel proportionLabel;
    private ColorEffect effect;
    private boolean debug;

    public ColorDetectionControl(ColorEffect effect) {
        this.effect = effect;
    }

    public Component getControlComponent() {
        if (this.component == null) {
            this.label = new JLabel("Set Pixel difference threshold:");
            this.proportionLabel = new JLabel("Set Proportion threshold:");
            this.button = new JButton("Color Debug");
            this.button.addActionListener(this);
            this.button.setToolTipText("Click to turn debugging mode on/off");
            this.threshold = new JSlider(0, 0, 10, ColorEffect.pixelThreshold / 4);
            this.threshold.setMajorTickSpacing(1);
            this.threshold.setPaintLabels(true);
            this.threshold.addChangeListener(this);
            this.proportionThreshold = new JSlider(0, 0, 10, (int)(ColorEffect.requiredProportion / 0.05f));
            this.proportionThreshold.setMajorTickSpacing(1);
            this.proportionThreshold.setPaintLabels(true);
            this.proportionThreshold.addChangeListener(this);
            Box componentPanel = Box.createVerticalBox();
            componentPanel.add(this.label);
            componentPanel.add(this.threshold);
            componentPanel.add(this.proportionLabel);
            componentPanel.add(this.proportionThreshold);
            componentPanel.invalidate();
            this.component = componentPanel;
        }
        return this.component;
    }

    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.button) {
            this.debug = !this.debug;
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object o = e.getSource();
        if (o == this.threshold) {
            ColorEffect.pixelThreshold = this.threshold.getValue() * 4;
        }
        if (o == this.proportionThreshold) {
            ColorEffect.requiredProportion = (float)this.proportionThreshold.getValue() * 0.05f;
        }
    }
}

