function s= spline_cuadratico(x,y)
%Calculo del spline cuadratico para n puntos
%Supuesto x1 < x2 < ... <xn
%Los datos x,y deben ser de igual dimension y vectores fila
%El output es de la forma: s = [c0 b0 a0;c1 b1 a1; ... ;c(n-1) b(n-1) a(n-1)]
h=zeros(2,1); 
n=length(x);
for i=1:(n-1)
    h(i)=x(i+1)-x(i);
end
A=zeros(3*(n-1)); b=zeros(3*(n-1),1);
%Condicion de interpolacion en xi i=1,...,(n-1)
for i=1:(n-1)
    A(i,3*(i-1)+1)=1;
end
%Condicion de interpolacion en xn
A(n,3*(n-2)+1)=1; A(n,3*(n-2)+2)=h(n-1); A(n,3*(n-2)+3)=h(n-1)^2;
%Condicion de continuidad en xi i=2,...,(n-1)
for i=2:(n-1)
    A(n+i-1,3*(i-2)+1)=1;
    A(n+i-1,3*(i-2)+2)=h(i-1);
    A(n+i-1,3*(i-2)+3)=h(i-1)^2;
    A(n+i-1,3*(i-2)+4)=-1;
end
%Condicion de continuidad de primera derivada en xi i=2,...,(n-1)
for i=2:(n-1)
    A(2*n-1+i-2,3*(i-2)+2)=1;
    A(2*n-1+i-2,3*(i-2)+3)=2*h(i-1);
    A(2*n-1+i-2,3*(i-2)+5)=-1;
end
%Condicion de continuidad de segunda derivada en x2
A(3*(n-1),3)=2;A(3*(n-1),6)=-2;
%Vector lado derecho
b=[y zeros(1,(2*n-3))]';
z=(A\b)';
%Salida del programa: s
s=zeros(n-1,3);
for i=1:(n-1)
    s(i,1:3)=z(3*i:-1:3*i-2);
end
%Grafico de la spline cuadratica
xx=zeros(n-1,20);
yy=zeros(n-1,20);
plot(x,y,'bo');
hold on
for i=1:(n-1)
    xx(i,1:20)=linspace(x(i),x(i+1),20);
    yy(i,1:20)=polyval(s(i,1:3),(xx(i,1:20)-x(i)));
    plot(xx(i,1:20),yy(i,1:20),'-r');
end
title(['Spline Cuadratico para n=',num2str(n),' puntos']);
end