function [x,error,iter]=gauss_seidel(A,b,Tol)
%Solucion del SEL A*x=b mediante Gauss-Seidel
%con tolerancia Tol
%Si no se entrega Tol se define valor por default
if nargin < 3
    Tol= 1e-6;
end
n=length(A);
%Calculo solucion metodo Gauss
sol=A\b;
%Calculo B,h metodo G-S
low=tril(A,-1);
up=triu(A,1);
d=diag(diag(A));
c=inv(d+low);
B=-c*up;
h=c*b;
%Ciclo principal G-S
iter=0;
x0=zeros(n,1);
error=norm(x0-sol);
%error=norm(A*x0-b);
while (error>Tol)
    x=B*x0+h;
    x0=x;
    iter=iter+1;
    error=norm(x0-sol);
    %error=norm(A*x0-b);
end
end