function [L,U,x] = crout(A,b)
%Factorizacion de Crout para una matriz de n x n.
%Tamao de A
n = length(A);
%Se crea la matriz L llena de ceros.
L = zeros(n);
%Se crea la matriz U como identidad de n x n.
U = eye(n);
%Se ejecuta el paso 1 del metodo de Crout.
L(1,1) = A(1,1);
U(1,2) = A(1,2)/L(1,1);
%Se ejecuta el paso 2 del metodo de Crout.
for k=2:(n-1)
    L(k,k-1) = A(k,k-1);
    L(k,k) = A(k,k) - L(k,k-1)*U(k-1,k);
    U(k,k+1) = A(k,k+1)/L(k,k);
end
%Termina el ciclo para la variable k.
%Se ejecuta el paso 3 del metodo de Crout.
L(n,n-1) = A(n,n-1);
L(n,n) = A(n,n) - L(n,n-1)*U(n-1,n);
%Se resuelve Ly=b 
y = L\b;
%Se resuelve Ux=y
x=U\y;
end