function v=Smooth4(u,iter)
%Smoothing rule automata para vecindad de Von Neumann
%para imagen en escala de gris
s=size(u);
nx=s(1);
ny=s(2);
v_old=u;
for k=1:iter
    v(1,1:ny)=u(1,1:ny);
    v(nx,1:ny)=u(nx,1:ny);
    v(1:nx,1)=u(1:nx,1);
    v(1:nx,ny)=u(1:nx,ny);
    for i=2:(nx-1)
        for j=2:(ny-1)
            nb=[v_old(i,j-1) v_old(i,j+1) v_old(i-1,j) v_old(i+1,j)];
            larg_eq_nb = (nb>=v_old(i,j));
            small_eq_nb = (nb<=v_old(i,j));
            q_larg_eq_nb = sum(larg_eq_nb);
            q_small_eq_nb = sum(small_eq_nb);
            if (q_larg_eq_nb>q_small_eq_nb) 
                v(i,j)=v_old(i,j)+1;
            elseif (q_small_eq_nb>q_larg_eq_nb)
                v(i,j)=v_old(i,j)-1;
            else
                v(i,j)=v_old(i,j);
            end
        end
    end
    v_old=v;
end
end