function v=NER4(u,iter)
%Nearest extremum rule automata con vecindad de Von Neumann
%para imagen en escala de gris
s=size(u);
nx=s(1);
ny=s(2);
v_old=u;
for k=1:iter
    v(1,1:ny)=u(1,1:ny);
    v(nx,1:ny)=u(nx,1:ny);
    v(1:nx,1)=u(1:nx,1);
    v(1:nx,ny)=u(1:nx,ny);
    for i=2:(nx-1)
        for j=2:(ny-1)
            nb=[v_old(i,j-1) v_old(i,j+1) v_old(i-1,j) v_old(i+1,j)];
            max_n=max(nb);
            min_n=min(nb);
            if ((max_n-v_old(i,j))<(v_old(i,j)-min_n)) 
                v(i,j)=max_n;
            elseif ((max_n-v_old(i,j))>(v_old(i,j)-min_n))
                v(i,j)=min_n;
            else
                v(i,j)=v_old(i,j);
            end
        end
    end
    v_old=v;
end
end