% Anomalia magnetica de campo total para esfera de radio R
% con su centro a profundidad h.  La esfera se considera magnetizada
% por el campo terrestre externo de magnitud B0, declinacion D e
% inclinacion I.  La suceptibilidad magnetica de la esfera es xemu
% en sistema emu o cgs.
%
% Calculo se lleva a cabo en una malla de puntos en la superficie.
% 
help anomagesfsurf
%
clear all
%
% Valores de campo magnetico para Stgo. en 2007.5 segun IGRF.
%
B0 = input('Intensidad de campo magnetico terrestre (nTesla o gammas) [20407] ?? ');
if(isempty(B0));B0=20407; end;

I = input('Inclinacion campo magnetico terrestre (Grados) [-33.35] ?? ');
if(isempty(I));I=-33.35; end;

D = input('Declinacion campo magnetico terrestre (Grados) [3.27] ?? ');
if(isempty(D));D=3.27; end;

h = input('Profundidad centro de esfera (m) [1000] ?? ');
if(isempty(h));h=1000; end;

R = input('Radio de esfera (m) [500] ?? ');
if(isempty(R));R=500; end;

xemu = input('Suceptibilidad magnetica de esfera (Sistema emu o cgs) [0.001] ?? ');
if(isempty(xemu));xemu=0.001; end;

%phi = input('rumbo de perfil respecto al Norte (grados) [0] ?? ');
%if(isempty(phi));phi=0; end;

nh  = input('Area de calculo en terminos de profundidad de centro de esfera [4] ?? ');
if(isempty(nh));nh=4; end;

ds = input('Distancia entre puntos de malla (m) [50] ?? ');
if(isempty(ds)); ds=50; end;

%
gr2rad = pi / 180;
ax     = cos(gr2rad*I) * cos(gr2rad*D);
ay     = cos(gr2rad*I) * sin(gr2rad*D);
az     = sin(gr2rad*I);
h2     = h^2;
c1     = xemu * B0 * 4 * pi / 3;
%
x      = -nh*h:ds:nh*h;
y      = x;
nx     = length(x);
ny     = nx;
%
for j=1:ny,
for i=1:nx,
    r        = sqrt(x(i)^2 + y(j)^2 + h2);
    dot      = (ax * x(i) + ay * y(j) - az * h ) / r;
    dot      = 3 * dot * dot - 1;
    act(i,j) = c1 * dot * (R/r)^3;
end
end

figure;
surfc(x,y,act);
shading interp;
colormap(jet);
xlabel('W-E (m)','FontSize',12);
ylabel('S-N (m)','FontSize',12);
texto = sprintf('B0, I, D, Xemu, R, h =%7.0f%7.1f%7.1f%10.4f%7.1f%7.1f',B0,I,D,xemu,R,h);
title(texto,'FontSize',12);
colorbar('vert');