% Perfil de anomalia magnetica de campo total para esfera de radio R
% con su centro a profundidad h.  La esfera se considera magnetizada
% por el campo terrestre externo de magnitud B0, declinacion D e
% inclinacion I.  La suceptibilidad magnetica de la esfera es xemu
% en sistema emu o cgs.
% 
% 
help anomagesfperf
%
clear all
%
% Valores de campo magnetico para Stgo. en 2007.5 segun IGRF.
%
B0 = input('Intensidad de campo magnetico terrestre (nTesla o gammas) [20407] ?? ');
if(isempty(B0));B0=20407; end;

I = input('Inclinacion campo magnetico terrestre (Grados) [-33.35] ?? ');
if(isempty(I));I=-33.35; end;

D = input('Declinacion campo magnetico terrestre (Grados) [3.27] ?? ');
if(isempty(D));D=3.27; end;

h = input('Profundidad centro de esfera (m) [1000] ?? ');
if(isempty(h));h=1000; end;

R = input('Radio de esfera (m) [500] ?? ');
if(isempty(R));R=500; end;

xemu = input('Suceptibilidad magnetica de esfera (Sistema emu o cgs) [0.001] ?? ');
if(isempty(xemu));xemu=0.001; end;

phi = input('rumbo de perfil respecto al Norte (grados) [0] ?? ');
if(isempty(phi));phi=0; end;

nh  = input('Largo del perfil en terminos de profundidad de centro de esfera [4] ?? ');
if(isempty(nh));nh=4; end;

ds = input('distancia entre puntos de perfil (m) [2] ?? ');
if(isempty(ds)); ds=2; end;

%
gr2rad = pi / 180;
ax     = cos(gr2rad*I) * cos(gr2rad*D);
ay     = cos(gr2rad*I) * sin(gr2rad*D);
az     = sin(gr2rad*I);
%
s      = -nh*h:ds:nh*h;
r      = sqrt(s.^2 + h^2); 
x      = s * cos(gr2rad*phi);
y      = s * sin(gr2rad*phi);
dot    = (ax * x + ay * y - az * h ) ./ r;
dot    = 3 * dot .* dot - 1;
%
act    = xemu * B0 * 4 * pi * dot .* (R./r).^3 / 3;

figure;
plot(s,act,'-b');
xlabel('s (m)','FontSize',12);
ylabel('Anom. Campo total (nT)','FontSize',12);
texto = sprintf('B0, I, D, Xemu, R, h =%7.0f%7.1f%7.1f%10.4f%7.1f%7.1f',B0,I,D,xemu,R,h);
title(texto,'FontSize',12);
grid on;