function  flexura(C1,C2)

clear all;

E = 1E9*input('E en GPa [100] : ');
if(isempty(E)); E=100E9 ; end;

S = input('Modulo de Poisson [0.25] : ');
if(isempty(S)); S=0.25 ; end;

h = 1000*input('h en km [100]: ');
if(isempty(h)); h=1E5 ; end;

D = E*h^3/(12*(1-S^2));

disp(sprintf('%s','    Densidades:'))

r1 = 1000*input('rho manto en gr/cc [3.3]: ');
if(isempty(r1)); r1=3300 ; end;

r2 = 1000*input('rho material de relleno en gr/cc [2.5]: ');
if(isempty(r2)); r2=2500 ; end;

g = 9.8;

alpha = (4*D/(g*(r1-r2)))^0.25;

disp(sprintf('%s','(A)   Flexura por carga puntual :'))

Vo = 1E9*input('Vo en GN/m [3500] : ');
if(isempty(Vo)); Vo=3.5E12 ; end;

x = linspace(-3*pi*alpha,3*pi*alpha,100);
y = abs(x);
z = (Vo*((alpha)^3)/(8*D))*exp(-y/alpha).*(cos(y/alpha)+sin(y/alpha));

plot(x,z)

disp(sprintf('%s','(B)   Flexura por flotacion y extension horizontal (subduccion):'))

r3 = 1000*input('rho slab en gr/cc [2.7] : ');
if(isempty(r3)); r3=2700 ; end;

L = 1E3*input('Largo Slab en km [300] : ');
if(isempty(L)); L=3E5 ; end;

P = 1E9*input('P en GPa*m [10] : ');
if(isempty(P)); P=1E10 ; end;

A = pi*input('Angulo de subduccion en  [25] : ')/180;
if(isempty(A)); A=pi*25/180 ; end;

eta = 4*(r1-r3)*g*D/(P^2);
mu = 0.5*((P/D)*(eta^0.5-1))^0.5;
nu = 0.5*((P/D)*(eta^0.5+1))^0.5;
aux = 0.5*(r1-r3)*g*h*L*cos(A)/P;
a = aux/(nu*(eta^0.5));
c = -a;
b = aux*(L/(eta-1)^0.5-1/(mu*eta^0.5));
d = -aux*(L/(eta-1)^0.5+1/(mu*eta^0.5));
x = linspace(0,L,100);
w = exp(nu*x).*(a*cos(mu*x)+b*sin(mu*x))+exp(-nu*x).*(c*cos(mu*x)+d*sin(mu*x));
% Grafico de w(x) vs. x
%plot(x,w,'-')
w1 = -x*tan(A);
x0 = x + w*sin(A);
w0 = w1 + w*cos(A);
% Grafico del slab
plot(x0,w0,x,w1,'-')
