% Integral de una exponencial

% Inicializamos las variables
clear; % clear workspace
%burocracia del grafico
set(gca,'NextPlot','replacechildren')

% metodo naive:
Tf = 40;
dt = 0.05;
gamma = 0.1;
t = 0:dt:Tf;

v1 = zeros(1,length(dt));
v2 = v1;

v1(1) = 1;
v2(1) = 1;

v1(2) = gamma*v1(1)*dt;
v2(2) = v2(1)*(1 - gamma*dt/2)/(1 + gamma*dt/2);;

for i=2:(length(t) - 1)
    v1(i+1) = v1(i-1)  - 2*gamma*v1(i)*dt; 
    v2(i+1) = v2(i)*(1 - gamma*dt/2)/(1 + gamma*dt/2); 
    %burocracia para graficar
    axis([0 40 0 2]); 
    figure(1)
    plot(t(1:i),v1(1:i),t(1:i),v2(1:i),'*')
    
    pelicula(i) = getframe;
end