% Problema de 3 cuerpos

% Inicializamos las variables
clear; % clear workspace
%burocracia del grafico
set(gca,'NextPlot','replacechildren')


n = 3; %numero de particulas
m = [1000 100 10]; % todas las masas distintas
Tf = 100;
dt = 0.01;
t =0:dt:Tf;
eps = 0.001;
% pedimos la memoria
x = zeros(3,length(t));
y = x;
vx = x;
vy = x;

% condiciones iniciales

x(:,1) = [0 4 8];
y(:,1) = [0 0 0];
vx(:,1) = [0 0 1];
vy(:,1) = [0 12 6];

x(:,2) = x(:,1) + vx(:,1)*dt;
y(:,2) = y(:,1) + vy(:,1)*dt;

for i=2:(length(t)-1)
    fuerza = zeros(3,1);
    for j=1:n % for sobre el numero de particulas
        for k=1:n
            if (j ~= k)
                aux = (x(j,i)-x(k,i)+eps)^2 + (y(j,i)-y(k,i) + eps)^2;
                fuerza(j) = fuerza(j) - m(k)/aux/sqrt(aux);
            end
        end
    end
    x(:,i+1) = 2*x(:,i) - x(:,i-1) + fuerza.*x(:,i)*dt^2;
    y(:,i+1) = 2*y(:,i) - y(:,i-1) + fuerza.*y(:,i)*dt^2;
    
    axis([-10 10 -10 10]); 
    figure(1)
    plot(x(1,1:i+1),y(1,1:i+1),'-y',x(2,1:i+1),y(2,1:i+1),'-',x(3,1:i+1),y(3,1:i+1),'-')
    
    pelicula(i) = getframe;
end
    

