%definimos las variables
clear
m=0.1;
g=9.8;
v0=10;
gama=0.1;
dt=0.01;
tfin=2;

%iniciamos los vectores
t = 0:dt:tfin;
y=zeros(1,length(t));
y(1)=0;
y(2)=v0*dt;
v=zeros(1,length(t));
v(1)=v0;
v(2)=v0 - g*v0*dt;

for i=2:(length(t)-1)
    y(i+1)=(gama*dt*y(i)/m - g*dt^2 + 2*y(i) - y(i-1))/(1 + gama*dt/m);
    v(i+1)=(-g*dt-gama*dt*v(i)/m) + v(i);
    if v(i+1)*v(i)<0
        hmax=y(i-1)
    end
end
plot(t,y)