function kiks_reginfo(edit)
global KIKS_REGINFO_GUI;

reginfo='';
cde='';
lic='';
vfk='';
org='';
name='';
email='';
licno='1';
lictype=1;
enabled='on';
title='Enter KiKS license data';
licno=1;

datapath = which('kiks_reginfo.mat');
if ~isempty(datapath)
    if nargin<1
        title='KiKS license data';
        enabled='off';
    end;
    load(datapath);
    if lic<0
        lictype=2;
        licno=sprintf('%d',abs(lic));
    end;
    if lic==0
        lictype=1;
        licno='1';
    end;
    if lic==Inf
        lictype=3;
        licno='1';
    end;
end;

h=dialog('Visible','off','PaperUnits','points');
set(h,'Name',title);
p=get(h,'Position');
xs=360;
ys=200;
p(1)=p(1)+(p(3)-xs)/2;
p(2)=p(2)+(p(4)-ys)/2;
p(3)=xs;
p(4)=ys;
set(h,'Position',p);

h1 = uicontrol('Parent',h, ...
    'FontName','verdana', ...
    'FontWeight','normal', ...
    'ListboxTop',0, ...
    'Position',[1 170 160 16], ...
    'HorizontalAlignment','right', ...
    'String','License type', ...
    'Style','text', ...
    'Tag','lictype_txt');
h1 = uicontrol('Parent',h, ...
    'Enable',enabled, ...
    'BackgroundColor',[1 1 1], ...
    'Callback','kiks_reginfo_lictypecallback;', ...
    'ListboxTop',0, ...
    'Position',[164 172 150 18], ...
    'String',{'Single user license','Multi-user license','Site license'}, ...
    'Style','popupmenu', ...
    'Tag','lictype', ...
    'Value',lictype);

h1 = uicontrol('Parent',h, ...
    'FontName','verdana', ...
    'FontWeight','normal', ...
    'ListboxTop',0, ...
    'Position',[1 150 160 16], ...
    'HorizontalAlignment','right', ...
    'String','Number of installations', ...
    'Style','text', ...
    'Enable',enabled, ...
    'Visible','off', ...
    'Tag','licno_txt');
if lictype==2
    set(h1,'Enable',enabled);
    set(h1,'Visible','on');
end;
h1 = uicontrol('Parent',h, ...
    'FontName','verdana', ...
    'BackgroundColor',[1 1 1], ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',[164 150 150 18], ...
    'String',licno, ...
    'Style','edit', ...
    'Tag','licno', ...
    'Enable',enabled, ...
    'Visible','off', ...
    'TooltipString','Number of licenses');
if lictype==2
    set(h1,'Enable',enabled);
    set(h1,'Visible','on');
end;

h1 = uicontrol('Parent',h, ...
    'FontName','verdana', ...
    'FontWeight','normal', ...
    'ListboxTop',0, ...
    'Position',[1 130 160 16], ...
    'HorizontalAlignment','right', ...
    'String','License number', ...
    'Style','text', ...
    'Tag','cde_txt');
h1 = uicontrol('Parent',h, ...
    'Enable',enabled, ...
    'FontName','verdana', ...
    'BackgroundColor',[1 1 1], ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',[164 130 150 18], ...
    'String',cde, ...
    'Style','edit', ...
    'Tag','cde', ...
    'TooltipString','License number');

h1 = uicontrol('Parent',h, ...
    'FontName','verdana', ...
    'FontWeight','normal', ...
    'ListboxTop',0, ...
    'Position',[1 110 160 16], ...
    'HorizontalAlignment','right', ...
    'String','Verification key', ...
    'Style','text', ...
    'Tag','vfk_txt');
h1 = uicontrol('Parent',h, ...
    'Enable',enabled, ...
    'FontName','verdana', ...
    'BackgroundColor',[1 1 1], ...
    'HorizontalAlignment','left', ...
    'ListboxTop',0, ...
    'Position',[164 110 150 18], ...
    'String',vfk, ...
    'Style','edit', ...
    'Tag','vfk', ...
    'TooltipString','Verification key');

if strcmp(enabled,'on')
    h1 = uicontrol('Parent',h, ...
    'FontName','verdana', ...
    'FontWeight','normal', ...
    'ListboxTop',0, ...
    'Position',[10 30 340 60], ...
    'HorizontalAlignment','left', ...
    'String','Make sure you have entered all information correctly before saving. Your license will be verified when you connect to a KiKSnet server.', ...
    'Style','text', ...
    'Tag','info_txt');
    h1 = uicontrol('Parent',h, ...
    'Callback','kiks_reginfo_write;', ...
    'ListboxTop',0, ...
    'Position',[10 10 100 20], ...
    'String','save license data', ...
    'Tag','save license data');
    h1 = uicontrol('Parent',h, ...
    'Callback','close;', ...
    'ListboxTop',0, ...
    'Position',[250 10 100 20], ...
    'String','close window', ...
    'Tag','close window');
else
    h1 = uicontrol('Parent',h, ...
    'Callback','close;kiks_reginfo(1);', ...
    'ListboxTop',0, ...
    'Position',[10 10 100 20], ...
    'String','edit license data', ...
    'Tag','edit license data');
    h1 = uicontrol('Parent',h, ...
    'Callback','close;', ...
    'ListboxTop',0, ...
    'Position',[250 10 100 20], ...
    'String','close window', ...
    'Tag','close window');
end;

set(h,'Visible','on');
