function kiks_gui_loghistory
global KIKS_HISTORY_HDL KIKS_GUI_HDL KIKS_LOG_HISTORY KIKS_STATUS_BUFFER KIKS_STATUS_BUFFER_CNT

if isempty(KIKS_HISTORY_HDL)
    h=figure('Visible','off',...
        'PaperUnits','points',...
        'CloseRequestFcn','kiks_gui_loghistory',...
        'Name','KiKS log history', ...
        'ToolBar','none', ...
        'KeypressFcn','kiks_matlab_focus', ...
        'Resize','on',...
        'ResizeFcn','p=get(gcf,''Position''); h=findobj(gcf,''tag'',''loghistory''); lp=get(h,''position''); lp(3:4)=p(3:4); set(h,''position'',lp);', ...
        'Menu','none', ...
        'NumberTitle','off');
    set(h,'Name','KiKS log history');
    p=get(h,'Position');
    xs=640;
    ys=460;
    p(1)=p(1)+(p(3)-xs)/2;
    p(2)=p(2)+(p(4)-ys)/2;
    p(3)=xs;
    p(4)=ys;
    set(h,'Position',p);
    h1 = uicontrol('Parent',h, ...
        'BackgroundColor',[1 1 1], ...
        'Units','pixels', ...
        'FontUnits','points', ...
        'FontName','Courier New', ...
        'FontSize',9, ...
        'FontWeight','normal', ...
        'HorizontalAlignment','left', ...
        'Position',[0 0 xs ys], ...
        'Style','listbox', ...
        'String',KIKS_STATUS_BUFFER(KIKS_LOG_HISTORY-KIKS_STATUS_BUFFER_CNT+1:KIKS_LOG_HISTORY),...
        'value',KIKS_STATUS_BUFFER_CNT,...
        'Tag','loghistory');
    
    KIKS_HISTORY_HDL=h;
    s=findobj(KIKS_GUI_HDL,'tag','togglelog');
    set(s,'string','close log history');
    set(KIKS_HISTORY_HDL,'Visible','on');
else
    delete(KIKS_HISTORY_HDL);
    KIKS_HISTORY_HDL=[];
    s=findobj(KIKS_GUI_HDL,'tag','togglelog');
    set(s,'string','view log history');
end;