///////////////////////////////////////////////////////////////////////////
////   Library for a MicroChip 93C56 configured for a x8 org           ////
////   Uses hardware SSP unit.                                         ////
////                                                                   ////
////   init_ext_F();    Call before the other functions are used  ////
////                                                                   ////
////   write_ext_F(a, d);  Write the byte d to the address a      ////
////                                                                   ////
////   d = read_ext_F(a);   Read the byte d from the address a    ////
////                                                                   ////
///////////////////////////////////////////////////////////////////////////
////        (C) Copyright 1996,2003 Custom Computer Services           ////
//// This source code may only be used by licensed users of the CCS C  ////
//// compiler.  This source code may only be distributed to other      ////
//// licensed users of the CCS C compiler.  No other use, reproduction ////
//// or distribution is permitted without written permission.          ////
//// Derivative programs created using this software in object code    ////
//// form are not restricted in any way.                               ////
///////////////////////////////////////////////////////////////////////////

#define F_SELECT PIN_B0
#define F_DI     PIN_C5
#define F_DO     PIN_C4
#define F_CLK    PIN_C3

void init_ext_F() {
   setup_spi(SPI_MASTER | SPI_H_TO_L | SPI_CLK_DIV_64 | SPI_SAMPLE_AT_END | SPI_XMIT_L_TO_H);
   output_high(F_SELECT);
}


void write_ext_F(BYTE add1, BYTE add2, BYTE add3, BYTE data) {

   output_low(F_SELECT);
   spi_write(0x06);
   output_high(F_SELECT);
   delay_us(4);
   output_low(F_SELECT);
   spi_write(0x02);
   spi_write(add1);
   spi_write(add2);
   spi_write(add3);
   spi_write(data);
   output_high(F_SELECT);
}


BYTE read_ext_F(BYTE add1, BYTE add2, BYTE add3) {
   BYTE data;

   output_low(F_SELECT);
   spi_write(0x03);
   spi_write(add1);
   spi_write(add2);
   spi_write(add3);

   data=spi_read(0);

   output_high(F_SELECT);


   return(data);
}

BYTE read_status() {
   BYTE data;

   output_low(F_SELECT);
   spi_write(0x05);
   data=spi_read(0);
   output_high(F_SELECT);


   return(data);
}

void write_status(BYTE data) {

   output_low(F_SELECT);
   spi_write(0x06);
   output_high(F_SELECT);
   delay_us(4);
   output_low(F_SELECT);
   spi_write(0x01);
   spi_write(data);
   output_high(F_SELECT);
}

void bulk_erase() {

   output_low(F_SELECT);
   spi_write(0x06);
   output_high(F_SELECT);
   delay_us(4);
   output_low(F_SELECT);
   spi_write(0xc7);
   output_high(F_SELECT);
}
