
;; HELPER FUNCTIONS

(define find-if
  (lambda (pred lst)
    (cond ((null? lst)      #f)
	  ((pred (car lst)) (car lst))
	  (else             (find-if pred (cdr lst))))))

(define collect-if
  (lambda (pred lst)
    (cond ((null? lst)      '())
	  ((pred (car lst)) (cons (car lst) (collect-if pred (cdr lst))))
	  (else             (collect-if pred (cdr lst))))))

(define find-position
  (lambda (sym lst)
    (let loop ((tail lst) (pos 0))
      (cond ((null? tail) #f)
	    ((eqv? sym (car tail)) pos)
	    (else (loop (cdr tail) (+ pos 1)))))))

(define find-last-position
  (lambda (sym lst)
    (let loop
	((tail lst) (curpos 0) (lastpos #f))
      (cond
       ((null? tail) lastpos)
       ((eqv? sym (car tail))
	(loop (cdr tail) (+ curpos 1) curpos))
       (else (loop (cdr tail) (+ curpos 1) lastpos))))))
