;; LOAD COMPLETE INTERPRETER FOR BASE

(load "misc.scm")
(load "ast.scm")
(load "parser.scm")
(load "base.scm")   

(define test
  (lambda (case result)
    (begin
      (if (eq? case result)
          (write "passed")
          (write "failed"))
      (newline))))

;; test cases
(test (run '((class Main Object
               (method void init ())
               (method void main () (+ 1 3))))) 4)

(test (run '((class Main Object
	      (method void init ())
	      (method void main () 
                      (send this init '())
                      (+ 1 (car (cdr '(1 3 4)))))))) 4)

;(run '((class Main Object
;	      (method void init ())
;	      (method int main () (+ 1 a)))))

(test (run `((class Main Object
	(method void init () (super init))
	(method int main ()
	  (let (((Employee john) (new Employee "john"))
		((Employee bob)  (new Employee "bob")))
	    (send john pay)
	    (send bob pay))))

      (class Employee Object
	(field string name)
	(method void init ((string name))
	  (super init)
	  (fset! name name))

	(method void print () (write (fget name)))

	(field int salary)
	(method int pay ()
	  (write 'paying:) (send this print) (newline)
	  (fget salary))))) 0)

(test (run `((class Main Object
	(method void init () (super init))
	(method int main () (send this fact 6))
	(method int fact ((int n))
	  (if (< n 1) 1
	      (* n (send this fact (- n 1)))))))) 720)


(test (run `((class Main Object
               (method void main ()
                       (let (((Figure fig)  (new Figure)))
                         (let (
                               ((Point  p1)  (send fig make-point   0  0))
                               ((Point  p2)  (send fig make-point  50 50))
                               ((Line   l1)  (send fig make-line   100 50 150 100))
                               ((Line   l2)  (send fig make-line   150 50 100 100)))
                           
                           (send fig dump)
                           (write "moving elements")(newline)
                           (send p1 set-x 30)
                           (send l2 set-p2 p2)
                           (send fig dump)))))
             
      (class Figure Object
	     (field LinkedList element-list)
	     (method void init () (super init)
		     (fset! element-list '()))

	     (method void dump ()
		     (write "figure:") (newline)
		     (send this dump-elements (fget element-list)))
        
	     (method void dump-elements ((LinkedList elements))
		     (if (null? elements)
			 'done
			 (let ()
			   (send (send elements first)
				 print)
			   (newline)
			   (send this dump-elements
				 (send elements next)))))

	     (method Point make-point ((int x) (int y))
		     (let (((Point p) (new Point x y)))
		       (fset! element-list
			    (new LinkedList p (fget element-list))
			    )		       
		       p))

	     (method Line make-line ((int x1) (int y1) (int x2) (int y2))
		     (let (((Point p1) (new Point x1 y1))
			   ((Point p2) (new Point x2 y2)))
		       (let (((Line l) (new Line p1 p2)))
			 (fset! element-list
				(new LinkedList l (fget element-list)))		       
			 l))))

      (class LinkedList Object
	     (field FigureElement el)
	     (field LinkedList next)
	     (method void init ((FigureElement el) (LinkedList next))
		     (super init)
		     (fset! el el)
		     (fset! next next))
	     (method FigureElement first () (fget el))
	     (method LinkedList next () (fget next)))

      (class FigureElement Object
	     (method void init () 
	       (super init))
	     (method void move-by ((int x) (int y)) 'done))
      
      (class Point FigureElement
	     (method void init ((int x) (int y)) 
		     (super init)
		     (fset! x x)
		     (fset! y y))
	     (field int x)
	     (field int y)
	     (method int get-x () (fget x))
	     (method int get-y () (fget y))
	     (method void set-x ((int x)) (fset! x x))
	     (method void set-y ((int y)) (fset! y y))
	     (method void move-by ((int x) (int y))
	       (send this set-x (+ x (send this get-x)))
	       (send this set-y (+ y (send this get-y))))

	     (method void print ()
		     (write 'Point<)
		     (write (send this get-x))
		     (write ':)
		     (write (send this get-y))
		     (write '>)
		     ))

      (class Line FigureElement
	     (method void init ((Point p1) (Point p2))
		     (fset! p1 p1)
		     (fset! p2 p2))
	     (field Point p1)
	     (field Point p2)
	     (method int get-p1 () (fget p1))
	     (method int get-p2 () (fget p2))
	     (method void set-p1 ((Point p1)) (fset! p1 p1))
	     (method void set-p2 ((Point p2)) (fset! p2 p2))
	     (method void move-by ((int x) (int y))
	       (send p1 move-by x y)
	       (send p2 move-by x y))

	     (method void print ()
		     (write 'line<)
		     (send (send this get-p1) print)
		     (write '-)
		     (send (send this get-p2) print)
		     (write '>))))) 'done)

(test (run `((class Point Object
               (field int x)
               (field int y)
               (method void init ()
                       (fset! x 0)
                       (fset! y 0))
               (method void movex ((int dx))
                       (fset! x (+ dx (fget x)))))
       
       (class XorO Point
         (field boolean x)
         (method void init ()
                 (super init)
                 (fset! x #f)))
       
       (class ColoredXorO XorO
         (field int c)
         (method void init ()
                 (super init)
                 (fset! c 1)))
       
       (class Main Object
         (method void main ()
                 (let (((Point o) (new ColoredXorO)))
                   (send o movex 1)
                   'done)))))
         
         
                 
                  'done)