
;; PARSER FOR BASE

(define parse-program
  (lambda (sexp)
    (make-program (parse-decls sexp))))

(define parse-decls
  (lambda (sexps)
    (map parse-decl sexps)))

(define parse-decl
  (lambda (sexp)
    (if (not (and (list? sexp)
		  (eqv? (car sexp) 'class)))
	(error 'parse-decl "Not a decl -- ~s" sexp)
	(make-class-decl (cadr sexp) 
			 (caddr sexp)
			 (parse-member-decls (cadr sexp) (cdddr sexp))))))

(define parse-member-decls
  (lambda (enclosing-cname sexps)
    (map (lambda (sexp) (parse-member-decl enclosing-cname sexp))
         sexps)))

(define parse-member-decl
  (lambda (enclosing-cname sexp)
    (or (and (list? sexp)
	     (case (car sexp)
	       ;;(field int x)
	       ((field) (make-field-decl enclosing-cname (cadr sexp) (caddr sexp)))
	       
	       ;; (method void setX ((int nx)) (fset! this x nx))
	       ((method) (make-method-decl enclosing-cname
                                           (cadr sexp)
                                           (caddr sexp)
                                           (parse-params (cadddr sexp))
                                           (parse-body (cddddr sexp))))))
	(error 'parse-member-decl "Not a member decl -- ~s" sexp))))

(define parse-params (lambda (sexps) (map parse-param sexps)))
(define parse-param  (lambda (sexp)  (make-param (car sexp) (cadr sexp))))
(define parse-body   (lambda (sexp)  (make-body (map parse-exp sexp))))

(define parse-exps  (lambda (exps) (map parse-exp exps)))

(define parse-exp
  (lambda (sexp)
    (cond ((or (number? sexp)
	       (string? sexp)
	       (eqv? sexp #t)
	       (eqv? sexp #f))
	   (make-lit-exp sexp))

	  ((and (list? sexp) (eqv? (car sexp) 'quote))
	   (make-lit-exp (cadr sexp)))	       
	       
	  ((symbol? sexp) (make-vget sexp))
	  
	  ((list? sexp)
           (let ((prim (assq (car sexp) *primitives*)))
	     (if prim
		 (make-prim-app-exp (cadr prim) (parse-exps (cdr sexp)))
                 
                 (case (car sexp)
                   ((if)
                    (make-if-exp (parse-exp (cadr sexp))
                                 (parse-exp (caddr sexp))
                                 (parse-exp (cadddr sexp))))
                   
                   ((let)
                    (make-let-exp (parse-params (map car (cadr sexp)))
                                  (parse-exps (map cadr (cadr sexp)))
                                  (parse-body (cddr sexp))))
		   
                   ((set!) (make-vset (cadr sexp) (parse-exp (caddr sexp))))
             
                   ;; oo language 
                   ((fget)  (make-fget (cadr sexp)))
                   
                   ((fset!) (make-fset (cadr sexp)
                                       (parse-exp (caddr sexp))))
                   
                   ((send)
                    (make-call (parse-exp (cadr sexp))
                               (caddr sexp)
                               (parse-exps (cdddr sexp))))
                   
                   ((super) (make-scall (cadr sexp) (parse-exps (cddr sexp))))
                   
                   ((new) (make-new (cadr sexp) (parse-exps (cddr sexp))))
                   
                   ((instanceof?) (make-instanceof (cadr sexp) (parse-exp (caddr sexp))))
                   
                   (else
                    (error 'parse-exp "not an expression -- ~s" sexp))))))
                 
                 (else (error 'parse-exp "not an expression -- ~s" sexp)))))
    


;;; primitives
(define *primitives*
  `((+       ,(lambda args (apply + args)))
    (-       ,(lambda args (apply - args)))
    (*       ,(lambda args (apply * args)))
    (/       ,(lambda args (apply / args)))
    (=       ,(lambda args (apply = args)))
    (<       ,(lambda args (apply < args)))
    (>       ,(lambda args (apply > args)))
    (zero?   ,(lambda args (apply zero? args)))

    (not     ,(lambda args (apply not args)))

    (write   ,(lambda args (apply write args)))
    (newline ,(lambda args (apply newline args)))

    (car     ,(lambda args (apply car  args)))
    (cdr     ,(lambda args (apply cdr  args)))
    (cons    ,(lambda args (apply cons args)))
    (list    ,(lambda args args))
    (length  ,(lambda args (apply length args)))
    (null?   ,(lambda args (apply null? args)))
    ))