
;; AST FOR BASE

;;; programs 
(define-struct program (decls))

;;; decls
(define-struct declaration ())
(define-struct (class-decl     declaration) (cname sname decls))       
(define-struct (member-decl    declaration) (cname))                   
(define-struct (method-decl    member-decl) (rtype mname params body)) 
(define-struct (field-decl     member-decl) (type fname))              

;;; method bodies
(define-struct body (exps))

;;; params
(define-struct param (type name))
(define pnames (lambda (params) (map param-name params)))
(define ptypes (lambda (params) (map param-type params)))

;;; expressions
(define-struct expression ())

(define-struct (lit-exp         expression) (value)) ;; number/string/boolean/list
(define-struct (prim-app-exp    expression) (prim args))
(define-struct (if-exp          expression) (test then else))
(define-struct (and-exp         expression) (args))
(define-struct (or-exp          expression) (args))
(define-struct (let-exp      expression) (params args body))

(define-struct (vget     expression) (name))
(define-struct (vset     expression) (name val))
(define-struct (fget     expression) (name))
(define-struct (fset     expression) (name val))
(define-struct (call    expression) (target sig args))
(define-struct (scall    expression) (sig args))
(define-struct (new      expression) (class args))
(define-struct (instanceof  expression) (class target))