;; dispatcher needs to be parametrized with actual self
(define (ppoint2 x y)
  (letrec ((x-var (box x))
           (y-var (box y))
           (g-self 
            (lambda (self) 
              (lambda (sel arg)
                (cond 
                  ((eq? sel 'getX) (unbox x-var))
                  ((eq? sel 'getY) (unbox y-var))
                  ((eq? sel 'setX) (set-box! x-var arg))
                  ((eq? sel 'setY) (set-box! y-var arg)) 
                  ((eq? sel 'reset) (begin  
                                      ((self self) 'setX 0)
                                      ((self self) 'setY 0))) 
                  ((eq? sel '_parent) g-self)
                  (else (error 'self "message not understood"))))))) 
    (g-self g-self))) ;; fix self

(printf "---~n")
(define a (ppoint2 2 3))
(a 'getX 0)
(a 'getY 0)
(a 'reset 0)
(a 'getX 0)
(a 'getY 0)

;; a is a "closed" dispatcher (self was fixed) - takes selector and arguments
a
;; (a '_parent) is "open" - takes a late-bound self 
(a '_parent 0)


(define (cpoint2 color x y)
  (letrec ((parent ((ppoint2 x y) '_parent 0)) ;; parent dispatcher (not fixed)
         (color-var (box color))
         (g-self
          (lambda (self)
            (lambda (sel arg)
              (cond 
                ((eq? sel 'getColor) (unbox color-var))
                ((eq? sel 'setColor) (set-box! color-var arg))
                ((eq? sel 'reset) (begin
                                    ((self self) 'setColor 'black)
                                    ((parent self) 'reset 0)))
                ((eq? sel 'setX) (begin
                                   (printf "setting x to ~a~n" arg)
                                   ((parent self) 'setX arg)))
                (else ((parent self) sel arg)))))))
    (g-self g-self)))

(printf "---~n")
(define b (cpoint2 'red 2 3))
(b 'getX 0)
(b 'getColor 0)
(b 'setX 5) ;; trace
(b 'reset 0) ;; trace!

