(define point
  (lambda (x y)
    (let* ((x-var (box x))    ; mutable state
           (y-var (box y)))   ;
      (define self            ; recursive definition of self
        (lambda (selector arg)
          (cond
            ((eq? selector 'getX) (unbox x-var))
            ((eq? selector 'getY) (unbox y-var))
            ((eq? selector 'setX) (set-box! x-var arg))
            ((eq? selector 'setY) (set-box! y-var arg))
            ((eq? selector 'sum) (+ (self 'getX) (self 'getY)))
            (else (error 'self "message not understood")) 
            )))
      self)))

;; extending point
(define cpoint
  (lambda (x y c)
    (let* ((parent (point x y))   ; parent object
           (c-var (box c)))
      (define self
        (lambda (selector arg)
          (cond 
            ((eq? selector 'getColor) (unbox c-var))
            ((eq? selector 'setColor) (set-box! c-var arg))
            (else (parent selector arg)))))  ; delegate to parent
      self)))
