(define-type FAE 
  [num (n number?)] 
  [add (lhs FAE?) (rhs FAE?)] 
  [id (name symbol?)] 
  [fun (param symbol?) (body FAE?)] 
  [app (fun-expr FAE?) (arg-expr FAE?)]
  )

(define-type FAE-Value 
  [numV (n number?)]
  [closureV (param symbol?) 
            (body FAE?) 
            (ds DefrdSub?)]
  )

(define-type DefrdSub
  [mtSub] 
  [aSub (name symbol?) (value FAE-Value?) (ds DefrdSub?)]
  ) 

;; lookup : symbol DefrdSub → FAE-Value 
(define (lookup name ds) 
  (type-case DefrdSub ds 
             [mtSub () (error ’lookup ”no binding for identifier”)] 
             [aSub (bound-name bound-value rest-ds) 
                   (if (symbol=? bound-name name) 
                       bound-value 
                       (lookup name rest-ds))]
             ))

;; num+ : numV numV → numV 
(define (num+ n1 n2) 
  (numV (+ (numV-n n1) (numV-n n2)))) 

(define (parse sexp)
  (cond
    [(number? sexp) (num sexp)]
    [(symbol? sexp) (id sexp)]
    [(list? sexp)
     (case (first sexp)
       [(+) (add (parse(second sexp))
                 (parse(third sexp)))]
       [(-) (sub (parse(second sexp))
                 (parse(third sexp)))]
       [(with) (app (fun (first (second sexp)) (parse(third sexp)))
                    (parse(second (second sexp))))]
       [(fun) (fun (first (second sexp))
                   (parse (third sexp)))] 
       [else (app (parse(first sexp))
                  (parse(second sexp)))]
       )
     ]
    ))


(define (interp expr ds) 
  (type-case FAE expr 
             [num (n) (numV n)] 
             [add (l r) (num+ (interp l ds) (interp r ds))] 
             [id (v) (lookup v ds)] 
             [fun (bound-id bound-body) 
                  (closureV bound-id bound-body ds)] 
             [app (fun-expr arg-expr) 
                  (local ([define fun-val (interp fun-expr ds)]) 
                    (interp (closureV-body fun-val) 
                            (aSub (closureV-param fun-val) 
                                  (interp arg-expr ds) 
                                  (closureV-ds fun-val))))]
             )) 

;(interp (parse '{with {double {fun {x} {+ x x}}} 
;                      {+ {double 10} 
;                         {double 5}}
;                      }
;               ) (mtSub))

;(interp (parse '{with {x 3} 
;                      {with {f {fun {y} {+ x y}}} 
;                            {with {x 5} 
;                                  {f 4}}
;                            }
;                      }
;               ) (mtSub))


