;; Arithmetic Expression data type
(define-type AE
  [num (n number?)]
  [add (lhs AE?)
       (rhs AE?)]
  [sub (lhs AE?)
       (rhs AE?)])

;; parse : sexp -> AE
;; to convert s-expressions into AEs
(define (parse sexp)
  (cond
    [(number? sexp) (num sexp)]
    [(list? sexp)
     (case (first sexp)
       [(+) (add (parse(second sexp))
                 (parse(third sexp)))]
       [(-) (sub (parse(second sexp))
                 (parse(third sexp)))]
       )]
    ))

;; a parse test case
(test (parse '3) (num 3))

(test (parse '(+ 1 2)) (add (num 1) (num 2)))

(parse '(+ (- 2 1) 3))

(test (parse '(+ (- 2 1) 3)) (add (sub (num 2) (num 1)) (num 3)))

; propuesto: Dibuje el AST asociado a la siguiente expresión
(parse '(+ (- (+ 1 2) 3) (- (+ 4 5) 6)))

; El interprete
(define (calc sexp)
  (type-case AE sexp
             [num (n) n] 
             [add (l r) (+ (calc l) (calc r))] 
             [sub (l r) (- (calc l) (calc r))]
             )) 

(calc (parse '(+ 1 2)))

(define (calculadora exp) (calc (parse exp)))

(calculadora '(+ 1 (- 2 3)))

