;
; Autor: Victor Ramiro - vramiro@dcc.uchile.cl
; Obs: Estos ejemplos funcionan en Scheme R5RS
;

; algunas funciones necesarias
(define (square x) (* x x))
(define (average x y) (/ (+ x y) 2))

; Ahora vamos a usar el metodo de newton para calcular la raiz de una funcion "conveniente"
; http://en.wikipedia.org/wiki/Newton%27s_method
; La funcion a buscar un cero es: y -> x - y^2
; notese que: x - y^2 = 0 => x = y^2 => y = sqrt(x)
(define (sqrt x)
  (newton 
   (lambda(y)(- x (square y))) 
   1.0))

; El metodo de newton:
;  y_{n+1} = y_n - [ f(y_n)/ f'(y_n) ]
;
; El método de newton puede reducirse a encontrar un punto fijo de la funcion: F(x): x -> x - f(x)/f'(x)
; Es decir, si F(x) = x => x = x - f(x)/f'(x) => - f(x)/f'(x) = 0 => f(x) = 0 
; Ya que f'(x) != 0.
;
(define (newton f guess)
  (define df (deriv f))
  (fixed-point
   (lambda(x)(- x (/ (f x)
                     (df x))
                ))
   guess))


; Solo nos falta la funcion deriv.
; Notemos que la funcion deriv recive una funcion f y retorna una funcion
(define deriv
  (lambda(f)
    (define dx .001)
    (lambda(x)
      (/ (- (f (+ x dx))
            (f x))
         dx))))

; La funcion para calcular puntos fijos de funciones
; f: funcion a la que se le busca el punto fijo
; start: punto de partida de la iteracion
;
; ver: http://en.wikipedia.org/wiki/Fixed_point_iteration

(define (fixed-point f start)
  (define (close-enuf? u v)
    (< (abs (- u v)) .001))
  (define (iter old new)
    (if (close-enuf? old new)
        new
        (iter new (f new))
        ))
  (iter start (f start)))
