;
; Autor: Victor Ramiro - vramiro@dcc.uchile.cl
; Obs: Estos ejemplos funcionan en Scheme R5RS
;

; algunas funciones necesarias
(define (square x) (* x x))
(define (average x y) (/ (+ x y) 2))

; ahora calculamos la raiz generalizando el metodo babilonico (clase 01)
; Dicho metodo es un punto fijo de la funcion que iterabamos
; Para ello calculamos el punto fijo a la funcion lambda (anonima) avg(y,x/y)
(define (sqrt x)
  (fixed-point 
   (lambda(y)(average y (/ x y)))
   1.0))

; La funcion para calcular puntos fijos de funciones
; f: funcion a la que se le busca el punto fijo
; start: punto de partida de la iteracion
;
; ver: http://en.wikipedia.org/wiki/Fixed_point_iteration
(define (fixed-point f start)
  (define (close-enuf? u v)
    (< (abs (- u v)) .001))
  (define (iter old new)
    (if (close-enuf? old new)
        new
        (iter new (f new))
        ))
  (iter start (f start)))

; Una generalizacion al metodo
; La funcion y->x/y tambien tiene como punto fijo a sqrt(x)
; El problema de esta funcion es que oscila entre 1 y x (problema tipico en analisis de sen~ales)
; La forma de solucionarlo es promediar la funcion (sic), para ello aplicamos (average-damp f)
; que recibe una funcione y *retorna* una nueva funcion que no oscila
(define (sqrt2 x)
  (fixed-point 
   (average-damp (lambda(y)(/ x y)))
   1.0))

; average-damp: recibe una funcion f y retorna una nueva funcion
; Notese el uso explicito de la notacion lambda
; http://en.wikipedia.org/wiki/Damping_factor (no es lo mismo que hicimos nosotros)
(define average-damp
  (lambda (f)
    (lambda(x)
      (average x (f x)))
    ))

; Otra forma de escribir la funcion
;(define (average-damp f)
;    (lambda(x)
;      (average x (f x)))
;    )