#include "nPipe.c"
#define NUM_PRODUCER 2
#define NUM_CONSUMER 2
#define BUFFER_SIZE 3

int producer(nPipe pipe, int num){
    int i;
    for (i=0; i<30; i++) {
        //costo de producir
        nSleep(10+(rand()%2000));
        char product = 97 + (i % 26);
        nPrintf("prod %d -> %c\n", num, product);
        nPutPipe(pipe, product);
    }
}

int consumer(nPipe pipe, int num){
    for (;;){
        char product = nGetPipe(pipe);
        if( product == EOF )
            break;
        nPrintf("\t\tcons %d -> %c\n", num, product);
        //costo de consumir
        nSleep(10+(rand()%5000));
    }
}

nMain() {
    nSetTimeSlice(10);
    srand(time(0));
    nPipe pipe = nMakePipe(BUFFER_SIZE);
    int i;
    nTask prod_task[NUM_PRODUCER], cons_task[NUM_CONSUMER];
    for(i=0; i<NUM_PRODUCER; ++i){
        prod_task[i] = nEmitTask(producer, pipe, i);
    }
    for(i=0; i<NUM_CONSUMER; ++i){
        cons_task[i] = nEmitTask(consumer, pipe, i);
    }
    for(i=0; i<NUM_PRODUCER; ++i){
        nWaitTask(prod_task[i]);
    }
    //parche: como no podemos cerrar el pipe, agregamos EOFs a mano para que terminen los consumers
    for(i=0; i<NUM_CONSUMER; ++i){
        nPutPipe(pipe, EOF);
    }
    for(i=0; i<NUM_CONSUMER; ++i){
        nWaitTask(cons_task[i]);
    }
    nClosePipe(pipe);
}
