#include <nSystem.h>

typedef struct nPipe {
    nSem sem_put;
    nSem sem_get;
    int size;
    char *buffer;
    int index;
    int index2;
    int closed;
} *nPipe;

nPipe nMakePipe(int buffer_size) {
    nPipe pipe;
    pipe = (nPipe) nMalloc(sizeof(*pipe));
    pipe->size = buffer_size;
    pipe->buffer = (char *) nMalloc(pipe->size * sizeof(char));
    pipe->index = pipe->index2 = 0;
    pipe->sem_get = nMakeSem(0);
    pipe->sem_put = nMakeSem(pipe->size);
    pipe->closed = FALSE;
    return pipe;
}

void nPutPipe(nPipe pipe, char c) {
    nWaitSem(pipe->sem_put);
    if(!pipe->closed){
        pipe->buffer[pipe->index] = c;
        pipe->index = (pipe->index + 1) % pipe->size;
    }
    nSignalSem(pipe->sem_get);
}

char nGetPipe(nPipe pipe) {
    nWaitSem(pipe->sem_get);
    if(pipe->closed){
        nSignalSem(pipe->sem_put);
        return '\0';
    }
    char ret = pipe->buffer[pipe->index2];
    pipe->index2 = (pipe->index2 + 1) % pipe->size;
    nSignalSem(pipe->sem_put);
    return ret;
}

void nClosePipe(nPipe pipe) {
    pipe->closed = TRUE;
    int i;
    for(i=0; i<pipe->size; ++i){
        nSignalSem(pipe->sem_put);
        nSignalSem(pipe->sem_get);
    }
}

void nDestroyPipe(nPipe pipe) {
    if(!pipe->closed)
        nFatalError("nFreePipe", "pipe debe haber sido cerrado previamente\n");
    nFree(pipe->sem_put);
    nFree(pipe->sem_get);
    nFree(pipe);
}
