#include <nSystem.h>

typedef struct nPipe {
    nMonitor mon;
    int size;
    char *buffer;
    int index;
    int length;
    int closed;
} *nPipe;

nPipe nMakePipe(int buffer_size) {
    nPipe pipe;
    pipe = (nPipe) nMalloc(sizeof(*pipe));
    pipe->size = buffer_size;
    pipe->buffer = (char *) nMalloc(pipe->size * sizeof(char));
    pipe->index = pipe->length = 0;
    pipe->mon = nMakeMonitor();
    pipe->closed = FALSE;
    return pipe;
}

void nPutPipe(nPipe pipe, char c) {
    nEnter(pipe->mon);
    while(pipe->length == pipe->size && !pipe->closed)
        nWait(pipe->mon);
    if(!pipe->closed){
        pipe->buffer[(pipe->index + pipe->length) % pipe->size] = c;
        pipe->length++;
        nNotifyAll(pipe->mon);
    }
    nExit(pipe->mon);
}

char nGetPipe(nPipe pipe) {
    nEnter(pipe->mon);
    while(pipe->length == 0 && !pipe->closed)
        nWait(pipe->mon);
    if(pipe->closed){
        nExit(pipe->mon);
        return '\0';
    }
    char ret = pipe->buffer[pipe->index];
    pipe->index = (pipe->index + 1) % pipe->size;
    pipe->length--;
    nNotifyAll(pipe->mon);
    nExit(pipe->mon);
    return ret;
}

void nClosePipe(nPipe pipe) {
    nEnter(pipe->mon);
    pipe->closed = TRUE;
    nNotifyAll(pipe->mon);
    nExit(pipe->mon);
}

void nDestroyPipe(nPipe pipe) {
    if(!pipe->closed)
        nFatalError("nFreePipe", "pipe debe haber sido cerrado previamente\n");
    nFree(pipe->mon);
    nFree(pipe);
}
