#include <nSystem.h>
#include <fifoqueues.h>

typedef struct nPipe {
    nTask server;
} *nPipe;

typedef struct {
    int op;
    char c;
    nTask task;
} Msg;

#define PUT     1
#define GET     2
#define CLOSE   3
#define DESTROY 4

int pipeServer(int buffer_size);

nPipe nMakePipe(int buffer_size) {
    nPipe pipe;
    pipe = (nPipe) nMalloc(sizeof(*pipe));
    pipe->server= nEmitTask(pipeServer, buffer_size);
    return pipe;
}

void nPutPipe(nPipe pipe, char c) {
    Msg msg;
    msg.op= PUT;
    msg.c= c;
    nSend(pipe->server, &msg);
}

char nGetPipe(nPipe pipe) {
    Msg msg;
    msg.op= GET;
    nSend(pipe->server, &msg);
    return msg.c;
}

void nClosePipe(nPipe pipe) {
    Msg msg;
    msg.op= CLOSE;
    nSend(pipe->server, &msg);
}

void nDestroyPipe(nPipe pipe) {
    Msg msg;
    msg.op= DESTROY;
    nSend(pipe->server, &msg);
    nWaitTask(pipe->server);
    nFree(pipe);
}

int pipeServer(int buffer_size){
    nSetTaskName("Task servidor de mensajes interno de nPipe");
    int index = 0, length = 0, size = buffer_size, closed = FALSE;
    char *buffer = (char *) nMalloc(size * sizeof(char));
    FifoQueue espera_espacio_queue = MakeFifoQueue();
    FifoQueue espera_datos_queue = MakeFifoQueue();
    nTask t;
    for(;;) {
        Msg *msg = (Msg *) nReceive(&t, -1);
        if(msg->op == PUT){
            if(closed){
                nReply(t, 0);
            } else if(length == size){
                msg->task= t;
                PutObj(espera_espacio_queue, msg);
            } else {
                buffer[(index + length) % size] = msg->c;
                length++;
                nReply(t, 0);
                //ver si habia una tarea esperando por datos
                if (!EmptyFifoQueue(espera_datos_queue)){
                    Msg *msg2 = (Msg *) GetObj(espera_datos_queue);
                    msg2->c = buffer[index];
                    index = (index + 1) % size;
                    length--;
                    nReply(msg2->task, 0);
                }
            }
        } else if(msg->op == GET){
            if(closed){
                msg->c = '\0';
                nReply(t, 0);
           } else if(length == 0){
                msg->task= t;
                PutObj(espera_datos_queue, msg);
            } else {
                msg->c = buffer[index];
                index = (index + 1) % size;
                length--;
                nReply(t, 0);
                //ver si habia una tarea esperando por espacio
                if (!EmptyFifoQueue(espera_espacio_queue)){
                    Msg *msg2 = (Msg *) GetObj(espera_espacio_queue);
                    buffer[(index + length) % size] = msg2->c;
                    length++;
                    nReply(msg2->task, 0);
                }
            }
        } else if(msg->op == CLOSE){
            closed = TRUE;
            while(!EmptyFifoQueue(espera_espacio_queue)){
                Msg *msg2 = (Msg *) GetObj(espera_espacio_queue);
                nReply(msg2->task, 0);
            }
            while(!EmptyFifoQueue(espera_datos_queue)){
                Msg *msg2 = (Msg *) GetObj(espera_datos_queue);
                msg2->c = '\0';
                nReply(msg2->task, 0);
            }
            nReply(t, 0);
        } else if(msg->op == DESTROY){
            nReply(t, 0);
            break;
        }
    }
}

