#include "nSysimp.h"
#include "nSystem.h"

typedef struct nPipe {
    struct Queue *espera_datos_queue;
    struct Queue *espera_espacio_queue;
    int size;
    char *buffer;
    int index;
    int length;
} *nPipe;

nPipe nMakePipe(int buffer_size) {
    nPipe pipe;
    pipe = (nPipe) nMalloc(sizeof(*pipe));
    pipe->size = buffer_size;
    pipe->buffer = (char *) nMalloc(buffer_size * sizeof(char));
    pipe->index = 0;
    pipe->length = 0;
    pipe->espera_datos_queue = MakeQueue();
    pipe->espera_espacio_queue = MakeQueue();
    return pipe;
}

void nPutPipe(nPipe pipe, char c) {
    START_CRITICAL();
    //ver si hay espacio en el buffer
    while(pipe->length == pipe->size) {
        //esperar a que se libere espacio en el buffer
        current_task->status = WAIT_SEM;
        PutTask(pipe->espera_espacio_queue, current_task);
        ResumeNextReadyTask();
    }
    //guardo el char
    pipe->buffer[(pipe->index + pipe->length) % pipe->size] = c;
    pipe->length++;
    //desbloquear un proceso bloqueado por datos
    if(!EmptyQueue(pipe->espera_datos_queue)) {
        nTask wait_task = GetTask(pipe->espera_datos_queue);
        wait_task->status = READY;
        PushTask(ready_queue, current_task);
        PushTask(ready_queue, wait_task);
        ResumeNextReadyTask();
    }
    END_CRITICAL();
}

char nGetPipe(nPipe pipe) {
    START_CRITICAL();
    //ver si hay datos en el buffer
    while(pipe->length == 0){
        //esperar a que lleguen datos
        current_task->status = WAIT_SEM;
        PutTask(pipe->espera_datos_queue, current_task);
        ResumeNextReadyTask();
    }
    //obtengo el char
    char ret = pipe->buffer[pipe->index];
    pipe->index = (pipe->index + 1) % pipe->size;
    pipe->length--;
    //desbloquear a un proceso bloqueado por espacio
    if (!EmptyQueue(pipe->espera_espacio_queue)) {
        nTask wait_task = GetTask(pipe->espera_espacio_queue);
        wait_task->status = READY;
        PushTask(ready_queue, current_task);
        PushTask(ready_queue, wait_task);
        ResumeNextReadyTask();
    }
    END_CRITICAL();
    return ret;
}

void nClosePipe(nPipe pipe) {
    START_CRITICAL();
    if(!EmptyQueue(pipe->espera_datos_queue) || !EmptyQueue(pipe->espera_espacio_queue))
        nFatalError("nClosePipe", "pipe con tareas esperando");
    DestroyQueue(pipe->espera_espacio_queue);
    DestroyQueue(pipe->espera_datos_queue);
    nFree(pipe);
    END_CRITICAL();
}
