int event_spinlock = OPEN;
int evento_ocurrido = FALSE;

Queue esperando_queue = kMakeQueue();

void kWait(){
    spinLock(event_spinlock);
    if(!evento_ocurrido){
        kProc current = currentProc();
        current -> status = WAIT_EVENT;
        kPutProc(esperando_queue, current);
        spinUnlock(event_spinlock);
        kResume();
    } else {
        spinUnlock(event_spinlock);
    }
}

void kNotify(){
    spinLock(event_spinlock);
    evento_ocurrido = TRUE;
    spinLock(ready_queue);
    kPushProc(ready_queue, currentProc());
    while(!kEmptyQueue(esperando_queue)){
        kProc proc = kGetProc(esperando_queue);
        proc -> status = READY;
        kPushProc(ready_queue, proc);
    }
    spinUnlock(ready_queue);
    spinUnlock(event_spinlock);
    kResume();
}
