/*
 * AUX 3 - CC41B
 * 31 de Agosto de 2007
 *
 * Prof.: Luis Mateu
 * Aux.: Juan Manuel Barrios
 *
 * Pregunta 2
 *
 * Para compilar:
 *    make APP=aux3p2
 */
#include <stdio.h>
#include "nSystem.h"

typedef struct Sem {
  int tickets;
  int visor;
  int numero;
  nMonitor ctrl;
} Sem;


Sem* make_sem(int tickets){
    Sem *sem = (Sem *) nMalloc(sizeof(Sem));
    sem->tickets = tickets;
    sem->visor = 0;
    sem->numero = 0;
    sem->ctrl = nMakeMonitor();
    return sem;
}
void wait_sem(Sem* sem){
    nEnter(sem->ctrl);
    int minum = sem->numero++;
    while(minum != sem->visor || sem->tickets == 0)
        nWait(sem->ctrl);
    sem->tickets--;
    sem->visor++;
    nNotifyAll(sem->ctrl);
    nExit(sem->ctrl);
}
void signal_sem(Sem* sem){
    nEnter(sem->ctrl);
    sem->tickets++;
    nNotifyAll(sem->ctrl);
    nExit(sem->ctrl);
}


Sem* s;
int escritor(int num);

nMain(){
	srand(time(0));
    s = make_sem(1);
    nTask t[5];
    int i;
    for(i=0; i<5; ++i){
        t[i] = nEmitTask(escritor, i);
    }
    for(i=0; i<5; ++i){
        nWaitTask(t[i]);
    }
}

int escritor(int num){
    int i;
    for(i=0; i<1; ++i){
        int milis = 500 + (rand() % 1000);
        wait_sem(s);
        nPrintf("tarea %i inicio escritura\n", num);
        nSleep(milis);
        nPrintf("tarea %i fin escritura\n", num);
        signal_sem(s);
	}
}
