/*
 * AUX 3 - CC41B
 * 24 de Agosto de 2007
 *
 * Prof.: Luis Mateu
 * Aux.: Juan Manuel Barrios
 *
 * Pregunta 2
 */

//sin paralelismo
int BuscarSeq(Node *node, int inf) {
    if (node == NULL)
        return FALSE;
    else if (inf == node->valor)
        return TRUE;
    else
        return BuscarSeq(node->izq, inf) || BuscarSeq(node->der, inf);
}

//opcion a
int BuscarSeq(Node *node, int inf) {
    if (node == NULL)
        return FALSE;
    else if (inf == node->valor)
        return TRUE;
    else {
        nTask task1 = nEmitTask(BuscarSeq, node->izq, inf);
        nTask task2 = nEmitTask(BuscarSeq, node->der, inf);
        int r1 = nWaitTask(task1);
        int r2 = nWaitTask(task2);
        return r1 || r2;
        //No hacer: return nWaitTask(task1) || nWaitTask(task2);
    }
}

//opcion b
int BuscarSeq(Node *node, int inf, int nivel) {
    if (node==NULL)
        return FALSE;
    else if (inf == node->valor)
        return TRUE;
    else {
        if (level <= 0) {
            return BuscarSeq(node->izq, inf, level) || BuscarSeq(node->der, inf, nivel);
        }
        else {
            nTask task1 = nEmitTask(BuscarSeq, node->izq, inf, level-1);
            nTask task2 = nEmitTask(BuscarSeq, node->der, inf, level-1);
            int r1 = nWaitTask(task1);
            int r2 = nWaitTask(task2);
            return r1 || r2;
        }
    }
}


//opcion c
int FOUND = FALSE;
nMonitor crtl = nMakeMonitor();

int BuscarSeq(Node *node, int inf, int nivel) {
    if (node==NULL)
        return FALSE;
    nEnter(ctrl);
    if(FOUND){
        nExit(ctrl);
        return TRUE;
    }
    nExit(ctrl);
    if (inf == node->valor){
        nEnter(ctrl);
        FOUND = TRUE;
        nExit(ctrl);
        return TRUE;
    } else {
        if (level <= 0) {
            return BuscarSeq(node->izq, inf, level) || BuscarSeq(node->der, inf, nivel);
        }
        else {
            nTask task1 = nEmitTask(BuscarSeq, node->izq, inf, level-1);
            nTask task2 = nEmitTask(BuscarSeq, node->der, inf, level-1);
            int r1 = nWaitTask(task1);
            int r2 = nWaitTask(task2);
            return r1 || r2;
        }
    }
}
