/*
 * AUX 1 - CC41B
 * 17 de Agosto de 2007
 *
 * Prof.: Luis Mateu
 * Aux.: Juan Manuel Barrios
 *
 * Ejemplo 2. Usar nSystem para el uso de I/O.
 * Genera en paralelo la cantidad de archivos que desee el usuario con una cantidad aleatoria de lineas.
 */
#include <stdio.h>
#include "nSystem.h"

#define MIN_LINEAS 3000
#define MAX_LINEAS 3500

int escritor(int num);

nMain(){
	//nSetTimeSlice(100); <-- si es que no va en paralelo
	nSetNonBlockingStdio();
	nPrintf("AUX 1\n");
	srand(time(0));
	nPrintf("Cantidad de archivos? ");
	char c[4];
	nRead(0, c, 3);
	int cant=atoi(c);
	if(cant <= 0)
	    return;
	nTask tareas[cant];
	int i;
	for (i=0; i<cant; ++i) {
		tareas[i] = nEmitTask(escritor, i);
	}
	for (i=0; i<cant; ++i) {
		nWaitTask(tareas[i]);
	}
	nPrintf("Fin AUX 1\n");
}

int escritor(int num) {
    char archiv[30];
	sprintf(archiv, "archivo%d.txt", num);
	int fd=nOpen(archiv, O_CREAT | O_WRONLY | O_TRUNC, 0644);
	nFprintf(fd, "Archivo %d\n\n", num);
	int lineas = MIN_LINEAS + (rand() % (MAX_LINEAS - MIN_LINEAS));
	nPrintf("Escribiendo archivo %s de %i lineas\n", archiv, lineas);
	int i;
	for (i=1; i<=lineas; ++i) {
    		nFprintf(fd, "linea %i: %i\n", i, rand());
	}
	nClose(fd);
	nPrintf("Archivo %s finalizado\n", archiv);
}
