type Identifier = String
type Value = Int

type FFunctionEnv = [FFunction]
type ValueEnv = [(Identifier, Value)]

type FFunction  = (Identifier, Identifier, F1WAE)

data F1WAE = Num Int
           | Add F1WAE F1WAE
           | Id Identifier
           | With Identifier F1WAE F1WAE
           | App Identifier F1WAE

interp :: F1WAE -> FFunctionEnv -> ValueEnv -> Value
interp (Num n) _ _ = n
interp (Add l r) fenv env = interp l fenv env + interp r fenv env
interp (Id i) _ env = lookupValueEnv i env
interp (App fun arg) fenv env = let (_, fun_param, fun_body) = lookupFunDef fun fenv
                                in interp fun_body fenv ((fun_param, interp arg fenv env) : env)
interp _ _ _ = error "not a valid expression"


lookupFunDef :: String -> FFunctionEnv -> FFunction
lookupFunDef _ [] = error "not found function: "
lookupFunDef s ((name, param, body) : next) = if s == name
                                              then (name, param, body)
                                              else lookupFunDef s next

lookupValueEnv :: String -> ValueEnv -> Value
lookupValueEnv _ [] = error "not found identifier: "
lookupValueEnv s ((i,v):next) = if s == i
                                then v
                                else lookupValueEnv s next

-- Must be 10
--interp (App "Double" (Num 5)) [("Double", "x", (Add (Id "x") (Id "x")))] []








