;; WAE
(define-type WAE
  [num (n number?)]
  [add (l WAE?) (r WAE?)]
  [sub (l WAE?) (r WAE?)]
  [with (name symbol?) (named-expr WAE?) (body WAE?)]
  [id (name symbol?)]
  )


;; parse : sexp -> WAE
(define (parse exp)
  (cond
    [(number? exp) (num exp)]
    [(symbol? exp) (id exp)]
    [(list? exp)
     (case (first exp)
       [(+) (add (parse (second exp)) (parse (third exp)))]
       [(-) (sub (parse (second exp)) (parse (third exp)))]
       [(with) (with (first (second exp)) (parse (second (second exp))) (parse (third exp)))]
       )
     ]
    )
  )


;; subst : WAE symbol WAE -> WAE
;; substitutes second argument with third argument in first argument,
;; as per the rules; the resulting exprresion contans 
;; no free instance of the second argument.
(define (subst expr sub-id val)
  (type-case WAE expr
             [num (n) expr]
             [add (l r) (add (subst l sub-id val) (subst r sub-id val))]
             [sub (l r) (sub (subst l sub-id val) (subst r sub-id val))]
             [with (bound-id named-expr bound-body)
                   (if (symbol=? bound-id sub-id)
                       (with bound-id
                             (subst named-expr sub-id val)
                             bound-body)
                       (with bound-id 
                             (subst named-expr sub-id val)
                             (subst bound-body sub-id val)
                             )
                       )
                   ]
             [id (v) (if (symbol=? v sub-id) val expr)]
             )
  )

;; interp : WAE -> number
;; evaluates WAE expressions by reducing them to numbers
(define (interp expr)
  (type-case WAE expr
             [num (n) n]
             [add (l r) (+ (interp l) (interp r))]
             [sub (l r) (- (interp l) (interp r))]
             [with (bound-id named-expr bound-body)
                   (interp (subst bound-body 
                                  bound-id
                                  (num (interp named-expr))
                                  )
                           )
                   ]
             [id (v) (error 'interp (format "free identifier: ~s" v))]
             )
  )


;; TEST'S
(test (interp (parse '5)) 5)
(test (interp (parse '{+ 5 5})) 10)
(test (interp (parse '{- 5 5})) 0)
(test (interp (parse '{with {x {+ 5 5}} {+ x x}})) 20)
(test (interp (parse '{with {x 5} {+ x x}})) 10)
(test (interp (parse '{with {x {+ 5 5}} {with {y {- x 3}} {+ y y}}})) 14)
(test (interp (parse '{with {x 5} {+ x {with {x 3} 10}}})) 15)
(test (interp (parse '{with {x 5} {+ x {with {x 3} x}}})) 8)
(test (interp (parse '{with {x 5} {+ x {with {y 3} x}}})) 10)
(test (interp (parse '{with {x 5} {with {y x} y}})) 5)
(test (interp (parse '{with {x 5} {with {x x} x}})) 5)
                                                
                                                

                               
                     
                             
                               
