;; F1WAE : Grammar
(define-type F1WAE
  [num (n number?)]
  [add (l F1WAE?) (r F1WAE?)]
  [sub (l F1WAE?) (r F1WAE?)]
  [mult (l F1WAE?) (r F1WAE?)]
  [with (name symbol?) (named-expr F1WAE?) (body F1WAE?)]
  [id (name symbol?)]
  [app (fun-name symbol?) (arg F1WAE?)]
  [if0 (condition F1WAE?) (truth F1WAE?) (falsity F1WAE?)]
  
  )

;; FunDef : Function Definition
(define-type FunDef
  [fundef (fun-name symbol?)
          (arg-name symbol?)
          (body F1WAE?)
          ]
  )

;; lookup-fundef : symbol list<FunDef> -> FunDef
(define (lookup-fundef fun-name fundefs)
  (cond
    [(empty? fundefs) (error fun-name "function not found")]
    [else (if (symbol=? fun-name (fundef-fun-name (first fundefs)))
              (first fundefs)
              (lookup-fundef fun-name (rest fundefs))                             
              )
          ]
    )
  )

;; parse : sexp -> F1WAE
(define (parse exp)
  (cond
    [(number? exp) (num exp)]
    [(symbol? exp) (id exp)]
    [(list? exp)
     (case (first exp)
       [(+) (add (parse (second exp)) (parse (third exp)))]
       [(-) (sub (parse (second exp)) (parse (third exp)))]
       [(*) (mult (parse (second exp)) (parse (third exp)))]
       [(with) (with (first (second exp)) (parse (second (second exp))) (parse (third exp)))]
       [(if0) (if0 (parse (second exp)) (parse (third exp)) (parse (fourth exp)))]
       [else (app (first exp) (parse (second exp)))]
       )
     ]
    )
  )

;; subst : F1WAE symbol F1WAE -> F1WAE
(define (subst expr sub-id val)
  (type-case F1WAE expr
             [num (n) expr]
             [add (l r) (add (subst l sub-id val) (subst r sub-id val))]
             [sub (l r) (sub (subst l sub-id val) (subst r sub-id val))]
             [mult (l r) (mult (subst l sub-id val) (subst r sub-id val))]
             [with (bound-id named-expr bound-body) 
                   (if (symbol=? bound-id sub-id)
                       (with bound-id
                             (subst named-expr sub-id val)
                             bound-body)
                       (with bound-id
                             (subst named-expr sub-id val)
                             (subst bound-body sub-id val)
                             )
                       )
                   ]
             [id (v) (if (symbol=? v sub-id) val expr)]
             [app (fun-name arg-expr)
                  (app fun-name (subst arg-expr sub-id val))
                  ]
             [if0 (c t f) (if0 (subst c sub-id val) (subst t sub-id val) (subst f sub-id val))]
             )
  )

;; interp : F1WAE list<FunDef> -> number
(define (interp expr fun-defs)
  (type-case F1WAE expr
             [num (n) n]
             [add (l r) (+ (interp l fun-defs) (interp r fun-defs))]
             [sub (l r) (- (interp l fun-defs) (interp r fun-defs))]
             [mult (l r) (* (interp l fun-defs) (interp r fun-defs))]
             [with (bound-id named-expr bound-body)
                   (interp (subst bound-body
                                  bound-id
                                  (num (interp named-expr fun-defs))
                                  )
                           fun-defs
                           )
                   ]
             [id (v) (error 'interp (format "free identifier: ~s" v))]
             [app (fun-name arg-expr)
                  (local ([define the-fun-def (lookup-fundef fun-name fun-defs)])
                    (interp (subst (fundef-body the-fun-def)
                                   (fundef-arg-name the-fun-def)
                                   (num (interp arg-expr fun-defs)))
                            fun-defs
                            )
                    )
                  ]
             [if0 (c t f)
                  (if (= 0 (interp c fun-defs))
                      (interp t fun-defs)
                      (interp f fun-defs)
                      )
                  ]
             )
  )

(define fundefs
  (list
   (fundef 'double 'x (parse '{+ x x}))
   (fundef 'id 'x (parse 'x))
   (fundef 'fact 'x (parse '{if0 x
                                 1
                                 {* x {fact {- x 1}}}})
           )
   )
  )

;; TEST's                               
(test (interp (parse '{id 10}) fundefs) 10)
(test (interp (parse '{double {double 5}}) fundefs) 20)
(test (interp (parse '{with {x 10} {double x}}) fundefs) 20)
(test (interp (parse '{fact 5}) fundefs) 120)