;; Arithmethic expressions
(define-type AEL
  [num (n number?)]
  [add (l list?)]
  [mult (l list?)]
  )

;; parse : sexp -> AEL
(define (parse sexp)
  (cond
    ((number? sexp) (num sexp))
    ((list? sexp)
     (case (first sexp)
       ((+) (add (map parse (rest sexp))))
       ((*) (mult (map parse (rest sexp))))
       )
     )
    )
  )

;; sum-l : list(number) -> number
(define (list-sum l)
  (cond
    ((empty? l) 0)
    (else (+ (first l) (list-sum (rest l))))
    )
  )

;; mult-l : list(number) -> number
(define (list-mult l)
  (cond
    ((empty? l) 1)
    (else (* (first l) (list-mult (rest l))))
    )
  )

;; calc : AE -> num
(define (calc exp)
  (type-case AEL exp
             [num (n) n]
             [add (l) (list-sum (map calc l))]
             [mult (l) (list-mult (map calc l))]
             )
  )

(calc (parse '{+ 1 2 3}))
(calc (parse '(* 1 2 3)))
(calc (parse '(+ (+ 1 2 3) (* 1 2 3))))
                 
             
  
