;; Represents a family tree
(define-type FamilyTree
  [unknown]
  [person (name string?)
          (eyecolor symbol?)
          (father FamilyTree?)
          (mother FamilyTree?)
          ]
  )

;; test
(define me-tree
  (person "me" 'brown
          (person "father" 'brown
                  (person "grandfather" 'green (unknown) (unknown))
                  (person "grandmother" 'brown (unknown) (unknown))
                  )
          (person "mother" 'blue
                  (unknown)
                  (unknown)
                  )
          )
  )

(define son-tree
  (person "son" 'black
          me-tree
          (person "girlfriend" 'black (unknown) (unknown))
          )
  )

;; count-persons : FamilyTree -> number
(define (count-persons tree)
  (type-case FamilyTree tree 
             [unknown () 0]
             [person (name eyes father mother)
                     (+ 1 (count-persons father) (count-persons mother))
                     ]
             )
  )        

(test (count-persons (unknown)) 0)
(test (count-persons me-tree) 5)
(test (count-persons son-tree) 7)


;; eye-colors : FamilyTree -> list(symbol)
(define (eye-color tree)
  (type-case FamilyTree tree
             [unknown () '()]
             [person (name eyes father mother)
                     (cons 
                      eyes
                      (append 
                       (eye-color father)
                       (eye-color mother)
                       )
                      )
                     ]
             )
  )

(eye-color (unknown))
(eye-color me-tree)
(eye-color son-tree)