;; Aux 3: CC41A Primavera 2007
;; Aux: Richard Ibarra Ramírez
;; Dudas/Comentarios : richard.ibarra@gmail.com


;; Arithmethic expressions
(define-type AE
  [num (n number?)]
  [add (l AE?) (r AE?)]
  [sub (l AE?) (r AE?)]
  )

;; parse : sexp -> AE
(define (parse sexp)
  (cond
    ((number? sexp) (num sexp))
    ((list? sexp)
     (case (first sexp)
       ((+) (add (parse (second sexp)) (parse (third sexp))))
       ((-) (sub (parse (second sexp)) (parse (third sexp))))
       )
     )
    )
  )

;; calc : AE -> num
(define (calc exp)
  (type-case AE exp
             [num (n) n]
             [add (l r) (+ (calc l) (calc r))]
             [sub (l r) (- (calc l) (calc r))]
             )
  )

;; Propuesto:

;; Lenguaje que soporte
;; (+ 1 2 3)
;; (* 1 2 3 4)
;; (+ (* 1 2 ...) (3 4 ...))
             
  
