;
; Autor: Victor Ramiro - vramiro@dcc.uchile.cl
; Obs: Estos ejemplos funcionan en Scheme R5RS
;

; Funciones como resultado
; primera version de 'objetos'
; Encapsulacion de estado y un dispatcher
(define (point x y)
  (lambda (fun)
    (cond 
      ((eq? fun 'getX) x)
      ((eq? fun 'getY) y)
      ((eq? fun 'dist) (sqrt (+ (* x x) (* y y))))
      ))
  )

(define p (point 1.0 2.0))
(p 'getX)
(p 'getY)
(p 'dist)

; Ejemplo de QuickSort

; La funcion para encontrar los elementos menores al pivote
(define (filter-<-pivot pivot l) 
  (cond 
    ((null? l) '())
    ((< (car l) pivot) (cons (car l) (filter-<-pivot pivot (cdr l)))) 
    (else (filter-<-pivot pivot (cdr l)))
    ))


; La funcion para encontrar los elementos mayores al pivote
(define (filter->-pivot pivot l) 
  (cond 
    ((null? l) '())
    ((> (car l) pivot) (cons (car l) (filter->-pivot pivot (cdr l)))) 
    (else (filter->-pivot pivot (cdr l)))
    ))

; Tiene algun sentido esto?
; por que mejor no pasar la funcion de comparacion como parametro?

; La funcion para encontrar los elementos "comp" al pivote
; donde comp puede ser remplazado por un simbolo que represente a una funcion: (x,y) -> {#t,#f}
; ejemplos de "cmp": > o < 
(define (filter-pivot cmp pivot l) 
  (cond 
    ((null? l) '())
    ((cmp (car l) pivot) (cons (car l) (filter-pivot pivot (cdr l)))) 
    (else (filter-pivot pivot (cdr l)))
    ))

; Filtrar es una tarea muy comun en computacion
; mejoremos nuestra funcion de modo que no dependa del pivote
; de algun modo la funcion de comparacion sabe contra quien comparar
; (en el caso de quicksort, sera contra el pivote)
(define (filter-any comp l) 
  (cond 
    ((null? l) '())
    ((comp (car l)) (cons (car l) (filter-any comp (cdr l))))
    (else (filter-any comp (cdr l)))
    ))

; veamos como queda quicksort ahora
(define (qs comp l) 
  (cond 
    ((null? l) '())
    (else
     (let ((pivot (car l))) 
       (append 
        (qs comp (filter-any (lambda (x) (comp x pivot)) (cdr l)))  ; notese que la lambda encapsula el valor del pivote para comparar
        (list pivot) 
        (qs comp (filter-any (lambda (x) (not (comp x pivot))) (cdr l)))
        )
       ))
    ))

(qs < '(3 1 4 6 2 5 9 7 8))
(qs > '(3 1 4 6 2 5 9 7 8))
